<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVendorItemTypesResponse StructType
 * @subpackage Structs
 */
class GetVendorItemTypesResponse extends AbstractStructBase
{
    /**
     * The Successful
     * @var bool
     */
    public $Successful;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Errors
     */
    public $Errors;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Warnings
     */
    public $Warnings;
    /**
     * The VendorItemTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VendorItemTypes
     */
    public $VendorItemTypes;
    /**
     * The PageNumber
     * @var int
     */
    public $PageNumber;
    /**
     * The PageSize
     * @var int
     */
    public $PageSize;
    /**
     * The TotalRecords
     * @var int
     */
    public $TotalRecords;
    /**
     * Constructor method for GetVendorItemTypesResponse
     * @uses GetVendorItemTypesResponse::setSuccessful()
     * @uses GetVendorItemTypesResponse::setErrors()
     * @uses GetVendorItemTypesResponse::setWarnings()
     * @uses GetVendorItemTypesResponse::setVendorItemTypes()
     * @uses GetVendorItemTypesResponse::setPageNumber()
     * @uses GetVendorItemTypesResponse::setPageSize()
     * @uses GetVendorItemTypesResponse::setTotalRecords()
     * @param bool $successful
     * @param \StructType\Errors $errors
     * @param \StructType\Warnings $warnings
     * @param \StructType\VendorItemTypes $vendorItemTypes
     * @param int $pageNumber
     * @param int $pageSize
     * @param int $totalRecords
     */
    public function __construct($successful = null, \StructType\Errors $errors = null, \StructType\Warnings $warnings = null, \StructType\VendorItemTypes $vendorItemTypes = null, $pageNumber = null, $pageSize = null, $totalRecords = null)
    {
        $this
            ->setSuccessful($successful)
            ->setErrors($errors)
            ->setWarnings($warnings)
            ->setVendorItemTypes($vendorItemTypes)
            ->setPageNumber($pageNumber)
            ->setPageSize($pageSize)
            ->setTotalRecords($totalRecords);
    }
    /**
     * Get Successful value
     * @return bool|null
     */
    public function getSuccessful()
    {
        return $this->Successful;
    }
    /**
     * Set Successful value
     * @param bool $successful
     * @return \StructType\GetVendorItemTypesResponse
     */
    public function setSuccessful($successful = null)
    {
        // validation for constraint: boolean
        if (!is_null($successful) && !is_bool($successful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($successful, true), gettype($successful)), __LINE__);
        }
        $this->Successful = $successful;
        return $this;
    }
    /**
     * Get Errors value
     * @return \StructType\Errors|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \StructType\Errors $errors
     * @return \StructType\GetVendorItemTypesResponse
     */
    public function setErrors(\StructType\Errors $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \StructType\Warnings|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \StructType\Warnings $warnings
     * @return \StructType\GetVendorItemTypesResponse
     */
    public function setWarnings(\StructType\Warnings $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get VendorItemTypes value
     * @return \StructType\VendorItemTypes|null
     */
    public function getVendorItemTypes()
    {
        return $this->VendorItemTypes;
    }
    /**
     * Set VendorItemTypes value
     * @param \StructType\VendorItemTypes $vendorItemTypes
     * @return \StructType\GetVendorItemTypesResponse
     */
    public function setVendorItemTypes(\StructType\VendorItemTypes $vendorItemTypes = null)
    {
        $this->VendorItemTypes = $vendorItemTypes;
        return $this;
    }
    /**
     * Get PageNumber value
     * @return int|null
     */
    public function getPageNumber()
    {
        return $this->PageNumber;
    }
    /**
     * Set PageNumber value
     * @param int $pageNumber
     * @return \StructType\GetVendorItemTypesResponse
     */
    public function setPageNumber($pageNumber = null)
    {
        // validation for constraint: int
        if (!is_null($pageNumber) && !(is_int($pageNumber) || ctype_digit($pageNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageNumber, true), gettype($pageNumber)), __LINE__);
        }
        $this->PageNumber = $pageNumber;
        return $this;
    }
    /**
     * Get PageSize value
     * @return int|null
     */
    public function getPageSize()
    {
        return $this->PageSize;
    }
    /**
     * Set PageSize value
     * @param int $pageSize
     * @return \StructType\GetVendorItemTypesResponse
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !(is_int($pageSize) || ctype_digit($pageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        $this->PageSize = $pageSize;
        return $this;
    }
    /**
     * Get TotalRecords value
     * @return int|null
     */
    public function getTotalRecords()
    {
        return $this->TotalRecords;
    }
    /**
     * Set TotalRecords value
     * @param int $totalRecords
     * @return \StructType\GetVendorItemTypesResponse
     */
    public function setTotalRecords($totalRecords = null)
    {
        // validation for constraint: int
        if (!is_null($totalRecords) && !(is_int($totalRecords) || ctype_digit($totalRecords))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalRecords, true), gettype($totalRecords)), __LINE__);
        }
        $this->TotalRecords = $totalRecords;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetVendorItemTypesResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
