<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetShippingManifestResponse StructType
 * @subpackage Structs
 */
class GetShippingManifestResponse extends AbstractStructBase
{
    /**
     * The Successful
     * @var bool
     */
    public $Successful;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Errors
     */
    public $Errors;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Warnings
     */
    public $Warnings;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The UserName
     * @var string
     */
    public $UserName;
    /**
     * The ShippingProviderCode
     * @var string
     */
    public $ShippingProviderCode;
    /**
     * The ShippingMethodCode
     * @var string
     */
    public $ShippingMethodCode;
    /**
     * The CashOnDelivery
     * @var bool
     */
    public $CashOnDelivery;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The ManifestItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ManifestItems
     */
    public $ManifestItems;
    /**
     * Constructor method for GetShippingManifestResponse
     * @uses GetShippingManifestResponse::setSuccessful()
     * @uses GetShippingManifestResponse::setErrors()
     * @uses GetShippingManifestResponse::setWarnings()
     * @uses GetShippingManifestResponse::setCode()
     * @uses GetShippingManifestResponse::setUserName()
     * @uses GetShippingManifestResponse::setShippingProviderCode()
     * @uses GetShippingManifestResponse::setShippingMethodCode()
     * @uses GetShippingManifestResponse::setCashOnDelivery()
     * @uses GetShippingManifestResponse::setStatus()
     * @uses GetShippingManifestResponse::setManifestItems()
     * @param bool $successful
     * @param \StructType\Errors $errors
     * @param \StructType\Warnings $warnings
     * @param string $code
     * @param string $userName
     * @param string $shippingProviderCode
     * @param string $shippingMethodCode
     * @param bool $cashOnDelivery
     * @param string $status
     * @param \StructType\ManifestItems $manifestItems
     */
    public function __construct($successful = null, \StructType\Errors $errors = null, \StructType\Warnings $warnings = null, $code = null, $userName = null, $shippingProviderCode = null, $shippingMethodCode = null, $cashOnDelivery = null, $status = null, \StructType\ManifestItems $manifestItems = null)
    {
        $this
            ->setSuccessful($successful)
            ->setErrors($errors)
            ->setWarnings($warnings)
            ->setCode($code)
            ->setUserName($userName)
            ->setShippingProviderCode($shippingProviderCode)
            ->setShippingMethodCode($shippingMethodCode)
            ->setCashOnDelivery($cashOnDelivery)
            ->setStatus($status)
            ->setManifestItems($manifestItems);
    }
    /**
     * Get Successful value
     * @return bool|null
     */
    public function getSuccessful()
    {
        return $this->Successful;
    }
    /**
     * Set Successful value
     * @param bool $successful
     * @return \StructType\GetShippingManifestResponse
     */
    public function setSuccessful($successful = null)
    {
        // validation for constraint: boolean
        if (!is_null($successful) && !is_bool($successful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($successful, true), gettype($successful)), __LINE__);
        }
        $this->Successful = $successful;
        return $this;
    }
    /**
     * Get Errors value
     * @return \StructType\Errors|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \StructType\Errors $errors
     * @return \StructType\GetShippingManifestResponse
     */
    public function setErrors(\StructType\Errors $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \StructType\Warnings|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \StructType\Warnings $warnings
     * @return \StructType\GetShippingManifestResponse
     */
    public function setWarnings(\StructType\Warnings $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\GetShippingManifestResponse
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\GetShippingManifestResponse
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get ShippingProviderCode value
     * @return string|null
     */
    public function getShippingProviderCode()
    {
        return $this->ShippingProviderCode;
    }
    /**
     * Set ShippingProviderCode value
     * @param string $shippingProviderCode
     * @return \StructType\GetShippingManifestResponse
     */
    public function setShippingProviderCode($shippingProviderCode = null)
    {
        // validation for constraint: string
        if (!is_null($shippingProviderCode) && !is_string($shippingProviderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingProviderCode, true), gettype($shippingProviderCode)), __LINE__);
        }
        $this->ShippingProviderCode = $shippingProviderCode;
        return $this;
    }
    /**
     * Get ShippingMethodCode value
     * @return string|null
     */
    public function getShippingMethodCode()
    {
        return $this->ShippingMethodCode;
    }
    /**
     * Set ShippingMethodCode value
     * @param string $shippingMethodCode
     * @return \StructType\GetShippingManifestResponse
     */
    public function setShippingMethodCode($shippingMethodCode = null)
    {
        // validation for constraint: string
        if (!is_null($shippingMethodCode) && !is_string($shippingMethodCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingMethodCode, true), gettype($shippingMethodCode)), __LINE__);
        }
        $this->ShippingMethodCode = $shippingMethodCode;
        return $this;
    }
    /**
     * Get CashOnDelivery value
     * @return bool|null
     */
    public function getCashOnDelivery()
    {
        return $this->CashOnDelivery;
    }
    /**
     * Set CashOnDelivery value
     * @param bool $cashOnDelivery
     * @return \StructType\GetShippingManifestResponse
     */
    public function setCashOnDelivery($cashOnDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($cashOnDelivery) && !is_bool($cashOnDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cashOnDelivery, true), gettype($cashOnDelivery)), __LINE__);
        }
        $this->CashOnDelivery = $cashOnDelivery;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\GetShippingManifestResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ManifestItems value
     * @return \StructType\ManifestItems|null
     */
    public function getManifestItems()
    {
        return $this->ManifestItems;
    }
    /**
     * Set ManifestItems value
     * @param \StructType\ManifestItems $manifestItems
     * @return \StructType\GetShippingManifestResponse
     */
    public function setManifestItems(\StructType\ManifestItems $manifestItems = null)
    {
        $this->ManifestItems = $manifestItems;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetShippingManifestResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
