<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetInventorySnapshotRequest StructType
 * @subpackage Structs
 */
class GetInventorySnapshotRequest extends AbstractStructBase
{
    /**
     * The ItemTypes
     * @var \StructType\ItemTypes
     */
    public $ItemTypes;
    /**
     * The UpdatedSinceInMinutes
     * @var int
     */
    public $UpdatedSinceInMinutes;
    /**
     * Constructor method for GetInventorySnapshotRequest
     * @uses GetInventorySnapshotRequest::setItemTypes()
     * @uses GetInventorySnapshotRequest::setUpdatedSinceInMinutes()
     * @param \StructType\ItemTypes $itemTypes
     * @param int $updatedSinceInMinutes
     */
    public function __construct(\StructType\ItemTypes $itemTypes = null, $updatedSinceInMinutes = null)
    {
        $this
            ->setItemTypes($itemTypes)
            ->setUpdatedSinceInMinutes($updatedSinceInMinutes);
    }
    /**
     * Get ItemTypes value
     * @return \StructType\ItemTypes|null
     */
    public function getItemTypes()
    {
        return $this->ItemTypes;
    }
    /**
     * Set ItemTypes value
     * @param \StructType\ItemTypes $itemTypes
     * @return \StructType\GetInventorySnapshotRequest
     */
    public function setItemTypes(\StructType\ItemTypes $itemTypes = null)
    {
        $this->ItemTypes = $itemTypes;
        return $this;
    }
    /**
     * Get UpdatedSinceInMinutes value
     * @return int|null
     */
    public function getUpdatedSinceInMinutes()
    {
        return $this->UpdatedSinceInMinutes;
    }
    /**
     * Set UpdatedSinceInMinutes value
     * @param int $updatedSinceInMinutes
     * @return \StructType\GetInventorySnapshotRequest
     */
    public function setUpdatedSinceInMinutes($updatedSinceInMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($updatedSinceInMinutes) && !(is_int($updatedSinceInMinutes) || ctype_digit($updatedSinceInMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($updatedSinceInMinutes, true), gettype($updatedSinceInMinutes)), __LINE__);
        }
        $this->UpdatedSinceInMinutes = $updatedSinceInMinutes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetInventorySnapshotRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
