<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetExportJobStatusRequest StructType
 * @subpackage Structs
 */
class GetExportJobStatusRequest extends AbstractStructBase
{
    /**
     * The JobCode
     * @var string
     */
    public $JobCode;
    /**
     * Constructor method for GetExportJobStatusRequest
     * @uses GetExportJobStatusRequest::setJobCode()
     * @param string $jobCode
     */
    public function __construct($jobCode = null)
    {
        $this
            ->setJobCode($jobCode);
    }
    /**
     * Get JobCode value
     * @return string|null
     */
    public function getJobCode()
    {
        return $this->JobCode;
    }
    /**
     * Set JobCode value
     * @param string $jobCode
     * @return \StructType\GetExportJobStatusRequest
     */
    public function setJobCode($jobCode = null)
    {
        // validation for constraint: string
        if (!is_null($jobCode) && !is_string($jobCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobCode, true), gettype($jobCode)), __LINE__);
        }
        $this->JobCode = $jobCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetExportJobStatusRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
