<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExportFilter StructType
 * @subpackage Structs
 */
class ExportFilter extends AbstractStructBase
{
    /**
     * The SelectedValues
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SelectedValues
     */
    public $SelectedValues;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The SelectedValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SelectedValue;
    /**
     * The DateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DateTime;
    /**
     * The DateRange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DateRange
     */
    public $DateRange;
    /**
     * The Checked
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Checked;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * Constructor method for ExportFilter
     * @uses ExportFilter::setSelectedValues()
     * @uses ExportFilter::setText()
     * @uses ExportFilter::setSelectedValue()
     * @uses ExportFilter::setDateTime()
     * @uses ExportFilter::setDateRange()
     * @uses ExportFilter::setChecked()
     * @uses ExportFilter::setId()
     * @param \StructType\SelectedValues $selectedValues
     * @param string $text
     * @param string $selectedValue
     * @param string $dateTime
     * @param \StructType\DateRange $dateRange
     * @param string $checked
     * @param string $id
     */
    public function __construct(\StructType\SelectedValues $selectedValues = null, $text = null, $selectedValue = null, $dateTime = null, \StructType\DateRange $dateRange = null, $checked = null, $id = null)
    {
        $this
            ->setSelectedValues($selectedValues)
            ->setText($text)
            ->setSelectedValue($selectedValue)
            ->setDateTime($dateTime)
            ->setDateRange($dateRange)
            ->setChecked($checked)
            ->setId($id);
    }
    /**
     * Get SelectedValues value
     * @return \StructType\SelectedValues|null
     */
    public function getSelectedValues()
    {
        return $this->SelectedValues;
    }
    /**
     * Set SelectedValues value
     * @param \StructType\SelectedValues $selectedValues
     * @return \StructType\ExportFilter
     */
    public function setSelectedValues(\StructType\SelectedValues $selectedValues = null)
    {
        $this->SelectedValues = $selectedValues;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \StructType\ExportFilter
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get SelectedValue value
     * @return string|null
     */
    public function getSelectedValue()
    {
        return $this->SelectedValue;
    }
    /**
     * Set SelectedValue value
     * @param string $selectedValue
     * @return \StructType\ExportFilter
     */
    public function setSelectedValue($selectedValue = null)
    {
        // validation for constraint: string
        if (!is_null($selectedValue) && !is_string($selectedValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectedValue, true), gettype($selectedValue)), __LINE__);
        }
        $this->SelectedValue = $selectedValue;
        return $this;
    }
    /**
     * Get DateTime value
     * @return string|null
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \StructType\ExportFilter
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get DateRange value
     * @return \StructType\DateRange|null
     */
    public function getDateRange()
    {
        return $this->DateRange;
    }
    /**
     * Set DateRange value
     * @param \StructType\DateRange $dateRange
     * @return \StructType\ExportFilter
     */
    public function setDateRange(\StructType\DateRange $dateRange = null)
    {
        $this->DateRange = $dateRange;
        return $this;
    }
    /**
     * Get Checked value
     * @return string|null
     */
    public function getChecked()
    {
        return $this->Checked;
    }
    /**
     * Set Checked value
     * @param string $checked
     * @return \StructType\ExportFilter
     */
    public function setChecked($checked = null)
    {
        // validation for constraint: string
        if (!is_null($checked) && !is_string($checked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checked, true), gettype($checked)), __LINE__);
        }
        $this->Checked = $checked;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\ExportFilter
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExportFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
