<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Customer StructType
 * @subpackage Structs
 */
class Customer extends AbstractStructBase
{
    /**
     * The ProvidesCForm
     * @var bool
     */
    public $ProvidesCForm;
    /**
     * The DualCompanyRetail
     * @var bool
     */
    public $DualCompanyRetail;
    /**
     * The Enabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Enabled;
    /**
     * The TaxExempted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $TaxExempted;
    /**
     * The RegisteredDealer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RegisteredDealer;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Pan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Pan;
    /**
     * The Tin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Tin;
    /**
     * The CstNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CstNumber;
    /**
     * The StNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StNumber;
    /**
     * The Website
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Website;
    /**
     * The BillingAddress
     * @var \StructType\WsPartyAddress
     */
    public $BillingAddress;
    /**
     * The ShippingAddress
     * @var \StructType\WsPartyAddress
     */
    public $ShippingAddress;
    /**
     * Constructor method for Customer
     * @uses Customer::setProvidesCForm()
     * @uses Customer::setDualCompanyRetail()
     * @uses Customer::setEnabled()
     * @uses Customer::setTaxExempted()
     * @uses Customer::setRegisteredDealer()
     * @uses Customer::setName()
     * @uses Customer::setCode()
     * @uses Customer::setPan()
     * @uses Customer::setTin()
     * @uses Customer::setCstNumber()
     * @uses Customer::setStNumber()
     * @uses Customer::setWebsite()
     * @uses Customer::setBillingAddress()
     * @uses Customer::setShippingAddress()
     * @param bool $providesCForm
     * @param bool $dualCompanyRetail
     * @param bool $enabled
     * @param bool $taxExempted
     * @param bool $registeredDealer
     * @param string $name
     * @param string $code
     * @param string $pan
     * @param string $tin
     * @param string $cstNumber
     * @param string $stNumber
     * @param string $website
     * @param \StructType\WsPartyAddress $billingAddress
     * @param \StructType\WsPartyAddress $shippingAddress
     */
    public function __construct($providesCForm = null, $dualCompanyRetail = null, $enabled = null, $taxExempted = null, $registeredDealer = null, $name = null, $code = null, $pan = null, $tin = null, $cstNumber = null, $stNumber = null, $website = null, \StructType\WsPartyAddress $billingAddress = null, \StructType\WsPartyAddress $shippingAddress = null)
    {
        $this
            ->setProvidesCForm($providesCForm)
            ->setDualCompanyRetail($dualCompanyRetail)
            ->setEnabled($enabled)
            ->setTaxExempted($taxExempted)
            ->setRegisteredDealer($registeredDealer)
            ->setName($name)
            ->setCode($code)
            ->setPan($pan)
            ->setTin($tin)
            ->setCstNumber($cstNumber)
            ->setStNumber($stNumber)
            ->setWebsite($website)
            ->setBillingAddress($billingAddress)
            ->setShippingAddress($shippingAddress);
    }
    /**
     * Get ProvidesCForm value
     * @return bool|null
     */
    public function getProvidesCForm()
    {
        return $this->ProvidesCForm;
    }
    /**
     * Set ProvidesCForm value
     * @param bool $providesCForm
     * @return \StructType\Customer
     */
    public function setProvidesCForm($providesCForm = null)
    {
        // validation for constraint: boolean
        if (!is_null($providesCForm) && !is_bool($providesCForm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($providesCForm, true), gettype($providesCForm)), __LINE__);
        }
        $this->ProvidesCForm = $providesCForm;
        return $this;
    }
    /**
     * Get DualCompanyRetail value
     * @return bool|null
     */
    public function getDualCompanyRetail()
    {
        return $this->DualCompanyRetail;
    }
    /**
     * Set DualCompanyRetail value
     * @param bool $dualCompanyRetail
     * @return \StructType\Customer
     */
    public function setDualCompanyRetail($dualCompanyRetail = null)
    {
        // validation for constraint: boolean
        if (!is_null($dualCompanyRetail) && !is_bool($dualCompanyRetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dualCompanyRetail, true), gettype($dualCompanyRetail)), __LINE__);
        }
        $this->DualCompanyRetail = $dualCompanyRetail;
        return $this;
    }
    /**
     * Get Enabled value
     * @return bool|null
     */
    public function getEnabled()
    {
        return $this->Enabled;
    }
    /**
     * Set Enabled value
     * @param bool $enabled
     * @return \StructType\Customer
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabled) && !is_bool($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enabled, true), gettype($enabled)), __LINE__);
        }
        $this->Enabled = $enabled;
        return $this;
    }
    /**
     * Get TaxExempted value
     * @return bool|null
     */
    public function getTaxExempted()
    {
        return $this->TaxExempted;
    }
    /**
     * Set TaxExempted value
     * @param bool $taxExempted
     * @return \StructType\Customer
     */
    public function setTaxExempted($taxExempted = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxExempted) && !is_bool($taxExempted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxExempted, true), gettype($taxExempted)), __LINE__);
        }
        $this->TaxExempted = $taxExempted;
        return $this;
    }
    /**
     * Get RegisteredDealer value
     * @return bool|null
     */
    public function getRegisteredDealer()
    {
        return $this->RegisteredDealer;
    }
    /**
     * Set RegisteredDealer value
     * @param bool $registeredDealer
     * @return \StructType\Customer
     */
    public function setRegisteredDealer($registeredDealer = null)
    {
        // validation for constraint: boolean
        if (!is_null($registeredDealer) && !is_bool($registeredDealer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($registeredDealer, true), gettype($registeredDealer)), __LINE__);
        }
        $this->RegisteredDealer = $registeredDealer;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Customer
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Customer
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Pan value
     * @return string|null
     */
    public function getPan()
    {
        return $this->Pan;
    }
    /**
     * Set Pan value
     * @param string $pan
     * @return \StructType\Customer
     */
    public function setPan($pan = null)
    {
        // validation for constraint: string
        if (!is_null($pan) && !is_string($pan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pan, true), gettype($pan)), __LINE__);
        }
        $this->Pan = $pan;
        return $this;
    }
    /**
     * Get Tin value
     * @return string|null
     */
    public function getTin()
    {
        return $this->Tin;
    }
    /**
     * Set Tin value
     * @param string $tin
     * @return \StructType\Customer
     */
    public function setTin($tin = null)
    {
        // validation for constraint: string
        if (!is_null($tin) && !is_string($tin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tin, true), gettype($tin)), __LINE__);
        }
        $this->Tin = $tin;
        return $this;
    }
    /**
     * Get CstNumber value
     * @return string|null
     */
    public function getCstNumber()
    {
        return $this->CstNumber;
    }
    /**
     * Set CstNumber value
     * @param string $cstNumber
     * @return \StructType\Customer
     */
    public function setCstNumber($cstNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cstNumber) && !is_string($cstNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cstNumber, true), gettype($cstNumber)), __LINE__);
        }
        $this->CstNumber = $cstNumber;
        return $this;
    }
    /**
     * Get StNumber value
     * @return string|null
     */
    public function getStNumber()
    {
        return $this->StNumber;
    }
    /**
     * Set StNumber value
     * @param string $stNumber
     * @return \StructType\Customer
     */
    public function setStNumber($stNumber = null)
    {
        // validation for constraint: string
        if (!is_null($stNumber) && !is_string($stNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stNumber, true), gettype($stNumber)), __LINE__);
        }
        $this->StNumber = $stNumber;
        return $this;
    }
    /**
     * Get Website value
     * @return string|null
     */
    public function getWebsite()
    {
        return $this->Website;
    }
    /**
     * Set Website value
     * @param string $website
     * @return \StructType\Customer
     */
    public function setWebsite($website = null)
    {
        // validation for constraint: string
        if (!is_null($website) && !is_string($website)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($website, true), gettype($website)), __LINE__);
        }
        $this->Website = $website;
        return $this;
    }
    /**
     * Get BillingAddress value
     * @return \StructType\WsPartyAddress|null
     */
    public function getBillingAddress()
    {
        return $this->BillingAddress;
    }
    /**
     * Set BillingAddress value
     * @param \StructType\WsPartyAddress $billingAddress
     * @return \StructType\Customer
     */
    public function setBillingAddress(\StructType\WsPartyAddress $billingAddress = null)
    {
        $this->BillingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get ShippingAddress value
     * @return \StructType\WsPartyAddress|null
     */
    public function getShippingAddress()
    {
        return $this->ShippingAddress;
    }
    /**
     * Set ShippingAddress value
     * @param \StructType\WsPartyAddress $shippingAddress
     * @return \StructType\Customer
     */
    public function setShippingAddress(\StructType\WsPartyAddress $shippingAddress = null)
    {
        $this->ShippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Customer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
