<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomFields StructType
 * @subpackage Structs
 */
class CustomFields extends AbstractStructBase
{
    /**
     * The CustomField
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\CustomField[]
     */
    public $CustomField;
    /**
     * Constructor method for CustomFields
     * @uses CustomFields::setCustomField()
     * @param \StructType\CustomField[] $customField
     */
    public function __construct(array $customField = array())
    {
        $this
            ->setCustomField($customField);
    }
    /**
     * Get CustomField value
     * @return \StructType\CustomField[]|null
     */
    public function getCustomField()
    {
        return $this->CustomField;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomField method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomField method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomFieldForArrayConstraintsFromSetCustomField(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customFieldsCustomFieldItem) {
            // validation for constraint: itemType
            if (!$customFieldsCustomFieldItem instanceof \StructType\CustomField) {
                $invalidValues[] = is_object($customFieldsCustomFieldItem) ? get_class($customFieldsCustomFieldItem) : sprintf('%s(%s)', gettype($customFieldsCustomFieldItem), var_export($customFieldsCustomFieldItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomField property can only contain items of type \StructType\CustomField, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomField value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomField[] $customField
     * @return \StructType\CustomFields
     */
    public function setCustomField(array $customField = array())
    {
        // validation for constraint: array
        if ('' !== ($customFieldArrayErrorMessage = self::validateCustomFieldForArrayConstraintsFromSetCustomField($customField))) {
            throw new \InvalidArgumentException($customFieldArrayErrorMessage, __LINE__);
        }
        $this->CustomField = $customField;
        return $this;
    }
    /**
     * Add item to CustomField value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomField $item
     * @return \StructType\CustomFields
     */
    public function addToCustomField(\StructType\CustomField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomField) {
            throw new \InvalidArgumentException(sprintf('The CustomField property can only contain items of type \StructType\CustomField, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomField[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomFields
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
