<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateASNRequest StructType
 * @subpackage Structs
 */
class CreateASNRequest extends AbstractStructBase
{
    /**
     * The PurchaseOrderCode
     * @var string
     */
    public $PurchaseOrderCode;
    /**
     * The VendorCode
     * @var string
     */
    public $VendorCode;
    /**
     * The ExpectedDeliveryDate
     * @var string
     */
    public $ExpectedDeliveryDate;
    /**
     * The AsnItems
     * @var \StructType\AsnItems
     */
    public $AsnItems;
    /**
     * The CustomFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFields
     */
    public $CustomFields;
    /**
     * Constructor method for CreateASNRequest
     * @uses CreateASNRequest::setPurchaseOrderCode()
     * @uses CreateASNRequest::setVendorCode()
     * @uses CreateASNRequest::setExpectedDeliveryDate()
     * @uses CreateASNRequest::setAsnItems()
     * @uses CreateASNRequest::setCustomFields()
     * @param string $purchaseOrderCode
     * @param string $vendorCode
     * @param string $expectedDeliveryDate
     * @param \StructType\AsnItems $asnItems
     * @param \StructType\CustomFields $customFields
     */
    public function __construct($purchaseOrderCode = null, $vendorCode = null, $expectedDeliveryDate = null, \StructType\AsnItems $asnItems = null, \StructType\CustomFields $customFields = null)
    {
        $this
            ->setPurchaseOrderCode($purchaseOrderCode)
            ->setVendorCode($vendorCode)
            ->setExpectedDeliveryDate($expectedDeliveryDate)
            ->setAsnItems($asnItems)
            ->setCustomFields($customFields);
    }
    /**
     * Get PurchaseOrderCode value
     * @return string|null
     */
    public function getPurchaseOrderCode()
    {
        return $this->PurchaseOrderCode;
    }
    /**
     * Set PurchaseOrderCode value
     * @param string $purchaseOrderCode
     * @return \StructType\CreateASNRequest
     */
    public function setPurchaseOrderCode($purchaseOrderCode = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseOrderCode) && !is_string($purchaseOrderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseOrderCode, true), gettype($purchaseOrderCode)), __LINE__);
        }
        $this->PurchaseOrderCode = $purchaseOrderCode;
        return $this;
    }
    /**
     * Get VendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @param string $vendorCode
     * @return \StructType\CreateASNRequest
     */
    public function setVendorCode($vendorCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCode) && !is_string($vendorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCode, true), gettype($vendorCode)), __LINE__);
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Get ExpectedDeliveryDate value
     * @return string|null
     */
    public function getExpectedDeliveryDate()
    {
        return $this->ExpectedDeliveryDate;
    }
    /**
     * Set ExpectedDeliveryDate value
     * @param string $expectedDeliveryDate
     * @return \StructType\CreateASNRequest
     */
    public function setExpectedDeliveryDate($expectedDeliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expectedDeliveryDate) && !is_string($expectedDeliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expectedDeliveryDate, true), gettype($expectedDeliveryDate)), __LINE__);
        }
        $this->ExpectedDeliveryDate = $expectedDeliveryDate;
        return $this;
    }
    /**
     * Get AsnItems value
     * @return \StructType\AsnItems|null
     */
    public function getAsnItems()
    {
        return $this->AsnItems;
    }
    /**
     * Set AsnItems value
     * @param \StructType\AsnItems $asnItems
     * @return \StructType\CreateASNRequest
     */
    public function setAsnItems(\StructType\AsnItems $asnItems = null)
    {
        $this->AsnItems = $asnItems;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \StructType\CustomFields|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \StructType\CustomFields $customFields
     * @return \StructType\CreateASNRequest
     */
    public function setCustomFields(\StructType\CustomFields $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateASNRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
