<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddItemToGatePassRequest StructType
 * @subpackage Structs
 */
class AddItemToGatePassRequest extends AbstractStructBase
{
    /**
     * The GatePassCode
     * @var string
     */
    public $GatePassCode;
    /**
     * The ItemCode
     * @var string
     */
    public $ItemCode;
    /**
     * The Reason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Reason;
    /**
     * Constructor method for AddItemToGatePassRequest
     * @uses AddItemToGatePassRequest::setGatePassCode()
     * @uses AddItemToGatePassRequest::setItemCode()
     * @uses AddItemToGatePassRequest::setReason()
     * @param string $gatePassCode
     * @param string $itemCode
     * @param string $reason
     */
    public function __construct($gatePassCode = null, $itemCode = null, $reason = null)
    {
        $this
            ->setGatePassCode($gatePassCode)
            ->setItemCode($itemCode)
            ->setReason($reason);
    }
    /**
     * Get GatePassCode value
     * @return string|null
     */
    public function getGatePassCode()
    {
        return $this->GatePassCode;
    }
    /**
     * Set GatePassCode value
     * @param string $gatePassCode
     * @return \StructType\AddItemToGatePassRequest
     */
    public function setGatePassCode($gatePassCode = null)
    {
        // validation for constraint: string
        if (!is_null($gatePassCode) && !is_string($gatePassCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gatePassCode, true), gettype($gatePassCode)), __LINE__);
        }
        $this->GatePassCode = $gatePassCode;
        return $this;
    }
    /**
     * Get ItemCode value
     * @return string|null
     */
    public function getItemCode()
    {
        return $this->ItemCode;
    }
    /**
     * Set ItemCode value
     * @param string $itemCode
     * @return \StructType\AddItemToGatePassRequest
     */
    public function setItemCode($itemCode = null)
    {
        // validation for constraint: string
        if (!is_null($itemCode) && !is_string($itemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemCode, true), gettype($itemCode)), __LINE__);
        }
        $this->ItemCode = $itemCode;
        return $this;
    }
    /**
     * Get Reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param string $reason
     * @return \StructType\AddItemToGatePassRequest
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddItemToGatePassRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
