<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Search ServiceType
 * @subpackage Services
 */
class Search extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SearchItemTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SearchItemTypesRequest $searchItemTypesRequest
     * @return \StructType\SearchItemTypesResponse|bool
     */
    public function SearchItemTypes(\StructType\SearchItemTypesRequest $searchItemTypesRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchItemTypes($searchItemTypesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SearchSaleOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SearchSaleOrderRequest $searchSaleOrderRequest
     * @return \StructType\SearchSaleOrderResponse|bool
     */
    public function SearchSaleOrder(\StructType\SearchSaleOrderRequest $searchSaleOrderRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->SearchSaleOrder($searchSaleOrderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SearchItemTypesResponse|\StructType\SearchSaleOrderResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
