<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WsShippingBox StructType
 * @subpackage Structs
 */
class WsShippingBox extends AbstractStructBase
{
    /**
     * The Length
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Length;
    /**
     * The Width
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Width;
    /**
     * The Height
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Height;
    /**
     * Constructor method for WsShippingBox
     * @uses WsShippingBox::setLength()
     * @uses WsShippingBox::setWidth()
     * @uses WsShippingBox::setHeight()
     * @param string $length
     * @param string $width
     * @param float $height
     */
    public function __construct($length = null, $width = null, $height = null)
    {
        $this
            ->setLength($length)
            ->setWidth($width)
            ->setHeight($height);
    }
    /**
     * Get Length value
     * @return string|null
     */
    public function getLength()
    {
        return $this->Length;
    }
    /**
     * Set Length value
     * @param string $length
     * @return \StructType\WsShippingBox
     */
    public function setLength($length = null)
    {
        // validation for constraint: string
        if (!is_null($length) && !is_string($length)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        $this->Length = $length;
        return $this;
    }
    /**
     * Get Width value
     * @return string|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param string $width
     * @return \StructType\WsShippingBox
     */
    public function setWidth($width = null)
    {
        // validation for constraint: string
        if (!is_null($width) && !is_string($width)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
    /**
     * Get Height value
     * @return float|null
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param float $height
     * @return \StructType\WsShippingBox
     */
    public function setHeight($height = null)
    {
        // validation for constraint: float
        if (!is_null($height) && !(is_float($height) || is_numeric($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->Height = $height;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WsShippingBox
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
