<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WsPartyAddress StructType
 * @subpackage Structs
 */
class WsPartyAddress extends AbstractStructBase
{
    /**
     * The AddressLine1
     * @var string
     */
    public $AddressLine1;
    /**
     * The AddressLine2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AddressLine2;
    /**
     * The City
     * @var string
     */
    public $City;
    /**
     * The StateCode
     * @var string
     */
    public $StateCode;
    /**
     * The Pincode
     * @var string
     */
    public $Pincode;
    /**
     * The Phone
     * @var string
     */
    public $Phone;
    /**
     * Constructor method for WsPartyAddress
     * @uses WsPartyAddress::setAddressLine1()
     * @uses WsPartyAddress::setAddressLine2()
     * @uses WsPartyAddress::setCity()
     * @uses WsPartyAddress::setStateCode()
     * @uses WsPartyAddress::setPincode()
     * @uses WsPartyAddress::setPhone()
     * @param string $addressLine1
     * @param string $addressLine2
     * @param string $city
     * @param string $stateCode
     * @param string $pincode
     * @param string $phone
     */
    public function __construct($addressLine1 = null, $addressLine2 = null, $city = null, $stateCode = null, $pincode = null, $phone = null)
    {
        $this
            ->setAddressLine1($addressLine1)
            ->setAddressLine2($addressLine2)
            ->setCity($city)
            ->setStateCode($stateCode)
            ->setPincode($pincode)
            ->setPhone($phone);
    }
    /**
     * Get AddressLine1 value
     * @return string|null
     */
    public function getAddressLine1()
    {
        return $this->AddressLine1;
    }
    /**
     * Set AddressLine1 value
     * @param string $addressLine1
     * @return \StructType\WsPartyAddress
     */
    public function setAddressLine1($addressLine1 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine1) && !is_string($addressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine1, true), gettype($addressLine1)), __LINE__);
        }
        $this->AddressLine1 = $addressLine1;
        return $this;
    }
    /**
     * Get AddressLine2 value
     * @return string|null
     */
    public function getAddressLine2()
    {
        return $this->AddressLine2;
    }
    /**
     * Set AddressLine2 value
     * @param string $addressLine2
     * @return \StructType\WsPartyAddress
     */
    public function setAddressLine2($addressLine2 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine2) && !is_string($addressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine2, true), gettype($addressLine2)), __LINE__);
        }
        $this->AddressLine2 = $addressLine2;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\WsPartyAddress
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get StateCode value
     * @return string|null
     */
    public function getStateCode()
    {
        return $this->StateCode;
    }
    /**
     * Set StateCode value
     * @param string $stateCode
     * @return \StructType\WsPartyAddress
     */
    public function setStateCode($stateCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateCode) && !is_string($stateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateCode, true), gettype($stateCode)), __LINE__);
        }
        $this->StateCode = $stateCode;
        return $this;
    }
    /**
     * Get Pincode value
     * @return string|null
     */
    public function getPincode()
    {
        return $this->Pincode;
    }
    /**
     * Set Pincode value
     * @param string $pincode
     * @return \StructType\WsPartyAddress
     */
    public function setPincode($pincode = null)
    {
        // validation for constraint: string
        if (!is_null($pincode) && !is_string($pincode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pincode, true), gettype($pincode)), __LINE__);
        }
        $this->Pincode = $pincode;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\WsPartyAddress
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WsPartyAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
