<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for vendorItemType StructType
 * @subpackage Structs
 */
class VendorItemType extends AbstractStructBase
{
    /**
     * The VendorCode
     * @var string
     */
    public $VendorCode;
    /**
     * The ItemSKU
     * @var string
     */
    public $ItemSKU;
    /**
     * The VendorItemSKU
     * @var string
     */
    public $VendorItemSKU;
    /**
     * The UnitPrice
     * @var float
     */
    public $UnitPrice;
    /**
     * The Inventory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Inventory;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Priority;
    /**
     * The Enabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Enabled;
    /**
     * The CustomFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFields
     */
    public $CustomFields;
    /**
     * Constructor method for vendorItemType
     * @uses VendorItemType::setVendorCode()
     * @uses VendorItemType::setItemSKU()
     * @uses VendorItemType::setVendorItemSKU()
     * @uses VendorItemType::setUnitPrice()
     * @uses VendorItemType::setInventory()
     * @uses VendorItemType::setPriority()
     * @uses VendorItemType::setEnabled()
     * @uses VendorItemType::setCustomFields()
     * @param string $vendorCode
     * @param string $itemSKU
     * @param string $vendorItemSKU
     * @param float $unitPrice
     * @param int $inventory
     * @param int $priority
     * @param bool $enabled
     * @param \StructType\CustomFields $customFields
     */
    public function __construct($vendorCode = null, $itemSKU = null, $vendorItemSKU = null, $unitPrice = null, $inventory = null, $priority = null, $enabled = null, \StructType\CustomFields $customFields = null)
    {
        $this
            ->setVendorCode($vendorCode)
            ->setItemSKU($itemSKU)
            ->setVendorItemSKU($vendorItemSKU)
            ->setUnitPrice($unitPrice)
            ->setInventory($inventory)
            ->setPriority($priority)
            ->setEnabled($enabled)
            ->setCustomFields($customFields);
    }
    /**
     * Get VendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @param string $vendorCode
     * @return \StructType\VendorItemType
     */
    public function setVendorCode($vendorCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCode) && !is_string($vendorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCode, true), gettype($vendorCode)), __LINE__);
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Get ItemSKU value
     * @return string|null
     */
    public function getItemSKU()
    {
        return $this->ItemSKU;
    }
    /**
     * Set ItemSKU value
     * @param string $itemSKU
     * @return \StructType\VendorItemType
     */
    public function setItemSKU($itemSKU = null)
    {
        // validation for constraint: string
        if (!is_null($itemSKU) && !is_string($itemSKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemSKU, true), gettype($itemSKU)), __LINE__);
        }
        $this->ItemSKU = $itemSKU;
        return $this;
    }
    /**
     * Get VendorItemSKU value
     * @return string|null
     */
    public function getVendorItemSKU()
    {
        return $this->VendorItemSKU;
    }
    /**
     * Set VendorItemSKU value
     * @param string $vendorItemSKU
     * @return \StructType\VendorItemType
     */
    public function setVendorItemSKU($vendorItemSKU = null)
    {
        // validation for constraint: string
        if (!is_null($vendorItemSKU) && !is_string($vendorItemSKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorItemSKU, true), gettype($vendorItemSKU)), __LINE__);
        }
        $this->VendorItemSKU = $vendorItemSKU;
        return $this;
    }
    /**
     * Get UnitPrice value
     * @return float|null
     */
    public function getUnitPrice()
    {
        return $this->UnitPrice;
    }
    /**
     * Set UnitPrice value
     * @param float $unitPrice
     * @return \StructType\VendorItemType
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: float
        if (!is_null($unitPrice) && !(is_float($unitPrice) || is_numeric($unitPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitPrice, true), gettype($unitPrice)), __LINE__);
        }
        $this->UnitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get Inventory value
     * @return int|null
     */
    public function getInventory()
    {
        return $this->Inventory;
    }
    /**
     * Set Inventory value
     * @param int $inventory
     * @return \StructType\VendorItemType
     */
    public function setInventory($inventory = null)
    {
        // validation for constraint: int
        if (!is_null($inventory) && !(is_int($inventory) || ctype_digit($inventory))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inventory, true), gettype($inventory)), __LINE__);
        }
        $this->Inventory = $inventory;
        return $this;
    }
    /**
     * Get Priority value
     * @return int|null
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param int $priority
     * @return \StructType\VendorItemType
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get Enabled value
     * @return bool|null
     */
    public function getEnabled()
    {
        return $this->Enabled;
    }
    /**
     * Set Enabled value
     * @param bool $enabled
     * @return \StructType\VendorItemType
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabled) && !is_bool($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enabled, true), gettype($enabled)), __LINE__);
        }
        $this->Enabled = $enabled;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \StructType\CustomFields|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \StructType\CustomFields $customFields
     * @return \StructType\VendorItemType
     */
    public function setCustomFields(\StructType\CustomFields $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VendorItemType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
