<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorInvoiceItems StructType
 * @subpackage Structs
 */
class VendorInvoiceItems extends AbstractStructBase
{
    /**
     * The VendorInvoiceItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\VendorInvoiceItem[]
     */
    public $VendorInvoiceItem;
    /**
     * Constructor method for VendorInvoiceItems
     * @uses VendorInvoiceItems::setVendorInvoiceItem()
     * @param \StructType\VendorInvoiceItem[] $vendorInvoiceItem
     */
    public function __construct(array $vendorInvoiceItem = array())
    {
        $this
            ->setVendorInvoiceItem($vendorInvoiceItem);
    }
    /**
     * Get VendorInvoiceItem value
     * @return \StructType\VendorInvoiceItem[]|null
     */
    public function getVendorInvoiceItem()
    {
        return $this->VendorInvoiceItem;
    }
    /**
     * This method is responsible for validating the values passed to the setVendorInvoiceItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVendorInvoiceItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVendorInvoiceItemForArrayConstraintsFromSetVendorInvoiceItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vendorInvoiceItemsVendorInvoiceItemItem) {
            // validation for constraint: itemType
            if (!$vendorInvoiceItemsVendorInvoiceItemItem instanceof \StructType\VendorInvoiceItem) {
                $invalidValues[] = is_object($vendorInvoiceItemsVendorInvoiceItemItem) ? get_class($vendorInvoiceItemsVendorInvoiceItemItem) : sprintf('%s(%s)', gettype($vendorInvoiceItemsVendorInvoiceItemItem), var_export($vendorInvoiceItemsVendorInvoiceItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VendorInvoiceItem property can only contain items of type \StructType\VendorInvoiceItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VendorInvoiceItem value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorInvoiceItem[] $vendorInvoiceItem
     * @return \StructType\VendorInvoiceItems
     */
    public function setVendorInvoiceItem(array $vendorInvoiceItem = array())
    {
        // validation for constraint: array
        if ('' !== ($vendorInvoiceItemArrayErrorMessage = self::validateVendorInvoiceItemForArrayConstraintsFromSetVendorInvoiceItem($vendorInvoiceItem))) {
            throw new \InvalidArgumentException($vendorInvoiceItemArrayErrorMessage, __LINE__);
        }
        $this->VendorInvoiceItem = $vendorInvoiceItem;
        return $this;
    }
    /**
     * Add item to VendorInvoiceItem value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorInvoiceItem $item
     * @return \StructType\VendorInvoiceItems
     */
    public function addToVendorInvoiceItem(\StructType\VendorInvoiceItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VendorInvoiceItem) {
            throw new \InvalidArgumentException(sprintf('The VendorInvoiceItem property can only contain items of type \StructType\VendorInvoiceItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->VendorInvoiceItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VendorInvoiceItems
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
