<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorAgreement StructType
 * @subpackage Structs
 */
class VendorAgreement extends AbstractStructBase
{
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The StartTime
     * @var string
     */
    public $StartTime;
    /**
     * The EndTime
     * @var string
     */
    public $EndTime;
    /**
     * The AgreementText
     * @var string
     */
    public $AgreementText;
    /**
     * Constructor method for VendorAgreement
     * @uses VendorAgreement::setName()
     * @uses VendorAgreement::setStartTime()
     * @uses VendorAgreement::setEndTime()
     * @uses VendorAgreement::setAgreementText()
     * @param string $name
     * @param string $startTime
     * @param string $endTime
     * @param string $agreementText
     */
    public function __construct($name = null, $startTime = null, $endTime = null, $agreementText = null)
    {
        $this
            ->setName($name)
            ->setStartTime($startTime)
            ->setEndTime($endTime)
            ->setAgreementText($agreementText);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\VendorAgreement
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get StartTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }
    /**
     * Set StartTime value
     * @param string $startTime
     * @return \StructType\VendorAgreement
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startTime, true), gettype($startTime)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }
    /**
     * Get EndTime value
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->EndTime;
    }
    /**
     * Set EndTime value
     * @param string $endTime
     * @return \StructType\VendorAgreement
     */
    public function setEndTime($endTime = null)
    {
        // validation for constraint: string
        if (!is_null($endTime) && !is_string($endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endTime, true), gettype($endTime)), __LINE__);
        }
        $this->EndTime = $endTime;
        return $this;
    }
    /**
     * Get AgreementText value
     * @return string|null
     */
    public function getAgreementText()
    {
        return $this->AgreementText;
    }
    /**
     * Set AgreementText value
     * @param string $agreementText
     * @return \StructType\VendorAgreement
     */
    public function setAgreementText($agreementText = null)
    {
        // validation for constraint: string
        if (!is_null($agreementText) && !is_string($agreementText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agreementText, true), gettype($agreementText)), __LINE__);
        }
        $this->AgreementText = $agreementText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VendorAgreement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
