<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetSaleOrderPriorityRequest StructType
 * @subpackage Structs
 */
class SetSaleOrderPriorityRequest extends AbstractStructBase
{
    /**
     * The SaleOrderCode
     * @var string
     */
    public $SaleOrderCode;
    /**
     * The Priority
     * @var string
     */
    public $Priority;
    /**
     * Constructor method for SetSaleOrderPriorityRequest
     * @uses SetSaleOrderPriorityRequest::setSaleOrderCode()
     * @uses SetSaleOrderPriorityRequest::setPriority()
     * @param string $saleOrderCode
     * @param string $priority
     */
    public function __construct($saleOrderCode = null, $priority = null)
    {
        $this
            ->setSaleOrderCode($saleOrderCode)
            ->setPriority($priority);
    }
    /**
     * Get SaleOrderCode value
     * @return string|null
     */
    public function getSaleOrderCode()
    {
        return $this->SaleOrderCode;
    }
    /**
     * Set SaleOrderCode value
     * @param string $saleOrderCode
     * @return \StructType\SetSaleOrderPriorityRequest
     */
    public function setSaleOrderCode($saleOrderCode = null)
    {
        // validation for constraint: string
        if (!is_null($saleOrderCode) && !is_string($saleOrderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleOrderCode, true), gettype($saleOrderCode)), __LINE__);
        }
        $this->SaleOrderCode = $saleOrderCode;
        return $this;
    }
    /**
     * Get Priority value
     * @return string|null
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param string $priority
     * @return \StructType\SetSaleOrderPriorityRequest
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: string
        if (!is_null($priority) && !is_string($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetSaleOrderPriorityRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
