<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchSaleOrderResponse StructType
 * @subpackage Structs
 */
class SearchSaleOrderResponse extends AbstractStructBase
{
    /**
     * The Successful
     * @var bool
     */
    public $Successful;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Errors
     */
    public $Errors;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Warnings
     */
    public $Warnings;
    /**
     * The TotalRecords
     * @var int
     */
    public $TotalRecords;
    /**
     * The SaleOrders
     * @var \StructType\SaleOrders
     */
    public $SaleOrders;
    /**
     * Constructor method for SearchSaleOrderResponse
     * @uses SearchSaleOrderResponse::setSuccessful()
     * @uses SearchSaleOrderResponse::setErrors()
     * @uses SearchSaleOrderResponse::setWarnings()
     * @uses SearchSaleOrderResponse::setTotalRecords()
     * @uses SearchSaleOrderResponse::setSaleOrders()
     * @param bool $successful
     * @param \StructType\Errors $errors
     * @param \StructType\Warnings $warnings
     * @param int $totalRecords
     * @param \StructType\SaleOrders $saleOrders
     */
    public function __construct($successful = null, \StructType\Errors $errors = null, \StructType\Warnings $warnings = null, $totalRecords = null, \StructType\SaleOrders $saleOrders = null)
    {
        $this
            ->setSuccessful($successful)
            ->setErrors($errors)
            ->setWarnings($warnings)
            ->setTotalRecords($totalRecords)
            ->setSaleOrders($saleOrders);
    }
    /**
     * Get Successful value
     * @return bool|null
     */
    public function getSuccessful()
    {
        return $this->Successful;
    }
    /**
     * Set Successful value
     * @param bool $successful
     * @return \StructType\SearchSaleOrderResponse
     */
    public function setSuccessful($successful = null)
    {
        // validation for constraint: boolean
        if (!is_null($successful) && !is_bool($successful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($successful, true), gettype($successful)), __LINE__);
        }
        $this->Successful = $successful;
        return $this;
    }
    /**
     * Get Errors value
     * @return \StructType\Errors|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \StructType\Errors $errors
     * @return \StructType\SearchSaleOrderResponse
     */
    public function setErrors(\StructType\Errors $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \StructType\Warnings|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \StructType\Warnings $warnings
     * @return \StructType\SearchSaleOrderResponse
     */
    public function setWarnings(\StructType\Warnings $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get TotalRecords value
     * @return int|null
     */
    public function getTotalRecords()
    {
        return $this->TotalRecords;
    }
    /**
     * Set TotalRecords value
     * @param int $totalRecords
     * @return \StructType\SearchSaleOrderResponse
     */
    public function setTotalRecords($totalRecords = null)
    {
        // validation for constraint: int
        if (!is_null($totalRecords) && !(is_int($totalRecords) || ctype_digit($totalRecords))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalRecords, true), gettype($totalRecords)), __LINE__);
        }
        $this->TotalRecords = $totalRecords;
        return $this;
    }
    /**
     * Get SaleOrders value
     * @return \StructType\SaleOrders|null
     */
    public function getSaleOrders()
    {
        return $this->SaleOrders;
    }
    /**
     * Set SaleOrders value
     * @param \StructType\SaleOrders $saleOrders
     * @return \StructType\SearchSaleOrderResponse
     */
    public function setSaleOrders(\StructType\SaleOrders $saleOrders = null)
    {
        $this->SaleOrders = $saleOrders;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchSaleOrderResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
