<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchSaleOrderRequest StructType
 * @subpackage Structs
 */
class SearchSaleOrderRequest extends AbstractStructBase
{
    /**
     * The DisplayOrderCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DisplayOrderCode;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The Channel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Channel;
    /**
     * The CustomerEmailOrMobile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CustomerEmailOrMobile;
    /**
     * The CustomerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CustomerName;
    /**
     * The CashOnDelivery
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CashOnDelivery;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FromDate;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ToDate;
    /**
     * The OnHold
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $OnHold;
    /**
     * The SearchOptions
     * @var \StructType\SearchOptions
     */
    public $SearchOptions;
    /**
     * The UpdatedSinceInMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UpdatedSinceInMinutes;
    /**
     * Constructor method for SearchSaleOrderRequest
     * @uses SearchSaleOrderRequest::setDisplayOrderCode()
     * @uses SearchSaleOrderRequest::setStatus()
     * @uses SearchSaleOrderRequest::setChannel()
     * @uses SearchSaleOrderRequest::setCustomerEmailOrMobile()
     * @uses SearchSaleOrderRequest::setCustomerName()
     * @uses SearchSaleOrderRequest::setCashOnDelivery()
     * @uses SearchSaleOrderRequest::setFromDate()
     * @uses SearchSaleOrderRequest::setToDate()
     * @uses SearchSaleOrderRequest::setOnHold()
     * @uses SearchSaleOrderRequest::setSearchOptions()
     * @uses SearchSaleOrderRequest::setUpdatedSinceInMinutes()
     * @param string $displayOrderCode
     * @param string $status
     * @param string $channel
     * @param string $customerEmailOrMobile
     * @param string $customerName
     * @param bool $cashOnDelivery
     * @param string $fromDate
     * @param string $toDate
     * @param bool $onHold
     * @param \StructType\SearchOptions $searchOptions
     * @param int $updatedSinceInMinutes
     */
    public function __construct($displayOrderCode = null, $status = null, $channel = null, $customerEmailOrMobile = null, $customerName = null, $cashOnDelivery = null, $fromDate = null, $toDate = null, $onHold = null, \StructType\SearchOptions $searchOptions = null, $updatedSinceInMinutes = null)
    {
        $this
            ->setDisplayOrderCode($displayOrderCode)
            ->setStatus($status)
            ->setChannel($channel)
            ->setCustomerEmailOrMobile($customerEmailOrMobile)
            ->setCustomerName($customerName)
            ->setCashOnDelivery($cashOnDelivery)
            ->setFromDate($fromDate)
            ->setToDate($toDate)
            ->setOnHold($onHold)
            ->setSearchOptions($searchOptions)
            ->setUpdatedSinceInMinutes($updatedSinceInMinutes);
    }
    /**
     * Get DisplayOrderCode value
     * @return string|null
     */
    public function getDisplayOrderCode()
    {
        return $this->DisplayOrderCode;
    }
    /**
     * Set DisplayOrderCode value
     * @param string $displayOrderCode
     * @return \StructType\SearchSaleOrderRequest
     */
    public function setDisplayOrderCode($displayOrderCode = null)
    {
        // validation for constraint: string
        if (!is_null($displayOrderCode) && !is_string($displayOrderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayOrderCode, true), gettype($displayOrderCode)), __LINE__);
        }
        $this->DisplayOrderCode = $displayOrderCode;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\SearchSaleOrderRequest
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Channel value
     * @return string|null
     */
    public function getChannel()
    {
        return $this->Channel;
    }
    /**
     * Set Channel value
     * @param string $channel
     * @return \StructType\SearchSaleOrderRequest
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: string
        if (!is_null($channel) && !is_string($channel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($channel, true), gettype($channel)), __LINE__);
        }
        $this->Channel = $channel;
        return $this;
    }
    /**
     * Get CustomerEmailOrMobile value
     * @return string|null
     */
    public function getCustomerEmailOrMobile()
    {
        return $this->CustomerEmailOrMobile;
    }
    /**
     * Set CustomerEmailOrMobile value
     * @param string $customerEmailOrMobile
     * @return \StructType\SearchSaleOrderRequest
     */
    public function setCustomerEmailOrMobile($customerEmailOrMobile = null)
    {
        // validation for constraint: string
        if (!is_null($customerEmailOrMobile) && !is_string($customerEmailOrMobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerEmailOrMobile, true), gettype($customerEmailOrMobile)), __LINE__);
        }
        $this->CustomerEmailOrMobile = $customerEmailOrMobile;
        return $this;
    }
    /**
     * Get CustomerName value
     * @return string|null
     */
    public function getCustomerName()
    {
        return $this->CustomerName;
    }
    /**
     * Set CustomerName value
     * @param string $customerName
     * @return \StructType\SearchSaleOrderRequest
     */
    public function setCustomerName($customerName = null)
    {
        // validation for constraint: string
        if (!is_null($customerName) && !is_string($customerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerName, true), gettype($customerName)), __LINE__);
        }
        $this->CustomerName = $customerName;
        return $this;
    }
    /**
     * Get CashOnDelivery value
     * @return bool|null
     */
    public function getCashOnDelivery()
    {
        return $this->CashOnDelivery;
    }
    /**
     * Set CashOnDelivery value
     * @param bool $cashOnDelivery
     * @return \StructType\SearchSaleOrderRequest
     */
    public function setCashOnDelivery($cashOnDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($cashOnDelivery) && !is_bool($cashOnDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cashOnDelivery, true), gettype($cashOnDelivery)), __LINE__);
        }
        $this->CashOnDelivery = $cashOnDelivery;
        return $this;
    }
    /**
     * Get FromDate value
     * @return string|null
     */
    public function getFromDate()
    {
        return $this->FromDate;
    }
    /**
     * Set FromDate value
     * @param string $fromDate
     * @return \StructType\SearchSaleOrderRequest
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        $this->FromDate = $fromDate;
        return $this;
    }
    /**
     * Get ToDate value
     * @return string|null
     */
    public function getToDate()
    {
        return $this->ToDate;
    }
    /**
     * Set ToDate value
     * @param string $toDate
     * @return \StructType\SearchSaleOrderRequest
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        $this->ToDate = $toDate;
        return $this;
    }
    /**
     * Get OnHold value
     * @return bool|null
     */
    public function getOnHold()
    {
        return $this->OnHold;
    }
    /**
     * Set OnHold value
     * @param bool $onHold
     * @return \StructType\SearchSaleOrderRequest
     */
    public function setOnHold($onHold = null)
    {
        // validation for constraint: boolean
        if (!is_null($onHold) && !is_bool($onHold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onHold, true), gettype($onHold)), __LINE__);
        }
        $this->OnHold = $onHold;
        return $this;
    }
    /**
     * Get SearchOptions value
     * @return \StructType\SearchOptions|null
     */
    public function getSearchOptions()
    {
        return $this->SearchOptions;
    }
    /**
     * Set SearchOptions value
     * @param \StructType\SearchOptions $searchOptions
     * @return \StructType\SearchSaleOrderRequest
     */
    public function setSearchOptions(\StructType\SearchOptions $searchOptions = null)
    {
        $this->SearchOptions = $searchOptions;
        return $this;
    }
    /**
     * Get UpdatedSinceInMinutes value
     * @return int|null
     */
    public function getUpdatedSinceInMinutes()
    {
        return $this->UpdatedSinceInMinutes;
    }
    /**
     * Set UpdatedSinceInMinutes value
     * @param int $updatedSinceInMinutes
     * @return \StructType\SearchSaleOrderRequest
     */
    public function setUpdatedSinceInMinutes($updatedSinceInMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($updatedSinceInMinutes) && !(is_int($updatedSinceInMinutes) || ctype_digit($updatedSinceInMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($updatedSinceInMinutes, true), gettype($updatedSinceInMinutes)), __LINE__);
        }
        $this->UpdatedSinceInMinutes = $updatedSinceInMinutes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchSaleOrderRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
