<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaleOrderItem StructType
 * @subpackage Structs
 */
class SaleOrderItem extends AbstractStructBase
{
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The ItemSKU
     * @var string
     */
    public $ItemSKU;
    /**
     * The ChannelProductId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ChannelProductId;
    /**
     * The ShippingMethodCode
     * @var string
     */
    public $ShippingMethodCode;
    /**
     * The GiftWrap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $GiftWrap;
    /**
     * The GiftMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GiftMessage;
    /**
     * The TotalPrice
     * @var float
     */
    public $TotalPrice;
    /**
     * The SellingPrice
     * @var float
     */
    public $SellingPrice;
    /**
     * The PrepaidAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PrepaidAmount;
    /**
     * The ShippingCharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ShippingCharges;
    /**
     * The ShippingMethodCharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ShippingMethodCharges;
    /**
     * The CashOnDeliveryCharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CashOnDeliveryCharges;
    /**
     * The Discount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Discount;
    /**
     * The GiftWrapCharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $GiftWrapCharges;
    /**
     * The VoucherCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VoucherCode;
    /**
     * The VoucherValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $VoucherValue;
    /**
     * The StoreCredit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $StoreCredit;
    /**
     * The PacketNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PacketNumber;
    /**
     * The CombinationIdentifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CombinationIdentifier;
    /**
     * The OnHold
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $OnHold;
    /**
     * The FacilityCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FacilityCode;
    /**
     * The RequiresCustomization
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RequiresCustomization;
    /**
     * The ShippingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AddressRef
     */
    public $ShippingAddress;
    /**
     * The CustomFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFields
     */
    public $CustomFields;
    /**
     * The ItemDetailFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemDetailFields
     */
    public $ItemDetailFields;
    /**
     * The StatusCode
     * @var string
     */
    public $StatusCode;
    /**
     * The ItemCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ItemCode;
    /**
     * The Color
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Color;
    /**
     * The Brand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Brand;
    /**
     * The Size
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Size;
    /**
     * The ItemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ItemName;
    /**
     * The ShippingPackageCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShippingPackageCode;
    /**
     * The Cancellable
     * @var bool
     */
    public $Cancellable;
    /**
     * The CancellationReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CancellationReason;
    /**
     * The CreatedOn
     * @var string
     */
    public $CreatedOn;
    /**
     * The UpdatedOn
     * @var string
     */
    public $UpdatedOn;
    /**
     * The SaleOrderCode
     * @var string
     */
    public $SaleOrderCode;
    /**
     * Constructor method for SaleOrderItem
     * @uses SaleOrderItem::setCode()
     * @uses SaleOrderItem::setItemSKU()
     * @uses SaleOrderItem::setChannelProductId()
     * @uses SaleOrderItem::setShippingMethodCode()
     * @uses SaleOrderItem::setGiftWrap()
     * @uses SaleOrderItem::setGiftMessage()
     * @uses SaleOrderItem::setTotalPrice()
     * @uses SaleOrderItem::setSellingPrice()
     * @uses SaleOrderItem::setPrepaidAmount()
     * @uses SaleOrderItem::setShippingCharges()
     * @uses SaleOrderItem::setShippingMethodCharges()
     * @uses SaleOrderItem::setCashOnDeliveryCharges()
     * @uses SaleOrderItem::setDiscount()
     * @uses SaleOrderItem::setGiftWrapCharges()
     * @uses SaleOrderItem::setVoucherCode()
     * @uses SaleOrderItem::setVoucherValue()
     * @uses SaleOrderItem::setStoreCredit()
     * @uses SaleOrderItem::setPacketNumber()
     * @uses SaleOrderItem::setCombinationIdentifier()
     * @uses SaleOrderItem::setOnHold()
     * @uses SaleOrderItem::setFacilityCode()
     * @uses SaleOrderItem::setRequiresCustomization()
     * @uses SaleOrderItem::setShippingAddress()
     * @uses SaleOrderItem::setCustomFields()
     * @uses SaleOrderItem::setItemDetailFields()
     * @uses SaleOrderItem::setStatusCode()
     * @uses SaleOrderItem::setItemCode()
     * @uses SaleOrderItem::setColor()
     * @uses SaleOrderItem::setBrand()
     * @uses SaleOrderItem::setSize()
     * @uses SaleOrderItem::setItemName()
     * @uses SaleOrderItem::setShippingPackageCode()
     * @uses SaleOrderItem::setCancellable()
     * @uses SaleOrderItem::setCancellationReason()
     * @uses SaleOrderItem::setCreatedOn()
     * @uses SaleOrderItem::setUpdatedOn()
     * @uses SaleOrderItem::setSaleOrderCode()
     * @param string $code
     * @param string $itemSKU
     * @param string $channelProductId
     * @param string $shippingMethodCode
     * @param bool $giftWrap
     * @param string $giftMessage
     * @param float $totalPrice
     * @param float $sellingPrice
     * @param float $prepaidAmount
     * @param float $shippingCharges
     * @param float $shippingMethodCharges
     * @param float $cashOnDeliveryCharges
     * @param float $discount
     * @param float $giftWrapCharges
     * @param string $voucherCode
     * @param float $voucherValue
     * @param float $storeCredit
     * @param int $packetNumber
     * @param string $combinationIdentifier
     * @param bool $onHold
     * @param string $facilityCode
     * @param bool $requiresCustomization
     * @param \StructType\AddressRef $shippingAddress
     * @param \StructType\CustomFields $customFields
     * @param \StructType\ItemDetailFields $itemDetailFields
     * @param string $statusCode
     * @param string $itemCode
     * @param string $color
     * @param string $brand
     * @param string $size
     * @param string $itemName
     * @param string $shippingPackageCode
     * @param bool $cancellable
     * @param string $cancellationReason
     * @param string $createdOn
     * @param string $updatedOn
     * @param string $saleOrderCode
     */
    public function __construct($code = null, $itemSKU = null, $channelProductId = null, $shippingMethodCode = null, $giftWrap = null, $giftMessage = null, $totalPrice = null, $sellingPrice = null, $prepaidAmount = null, $shippingCharges = null, $shippingMethodCharges = null, $cashOnDeliveryCharges = null, $discount = null, $giftWrapCharges = null, $voucherCode = null, $voucherValue = null, $storeCredit = null, $packetNumber = null, $combinationIdentifier = null, $onHold = null, $facilityCode = null, $requiresCustomization = null, \StructType\AddressRef $shippingAddress = null, \StructType\CustomFields $customFields = null, \StructType\ItemDetailFields $itemDetailFields = null, $statusCode = null, $itemCode = null, $color = null, $brand = null, $size = null, $itemName = null, $shippingPackageCode = null, $cancellable = null, $cancellationReason = null, $createdOn = null, $updatedOn = null, $saleOrderCode = null)
    {
        $this
            ->setCode($code)
            ->setItemSKU($itemSKU)
            ->setChannelProductId($channelProductId)
            ->setShippingMethodCode($shippingMethodCode)
            ->setGiftWrap($giftWrap)
            ->setGiftMessage($giftMessage)
            ->setTotalPrice($totalPrice)
            ->setSellingPrice($sellingPrice)
            ->setPrepaidAmount($prepaidAmount)
            ->setShippingCharges($shippingCharges)
            ->setShippingMethodCharges($shippingMethodCharges)
            ->setCashOnDeliveryCharges($cashOnDeliveryCharges)
            ->setDiscount($discount)
            ->setGiftWrapCharges($giftWrapCharges)
            ->setVoucherCode($voucherCode)
            ->setVoucherValue($voucherValue)
            ->setStoreCredit($storeCredit)
            ->setPacketNumber($packetNumber)
            ->setCombinationIdentifier($combinationIdentifier)
            ->setOnHold($onHold)
            ->setFacilityCode($facilityCode)
            ->setRequiresCustomization($requiresCustomization)
            ->setShippingAddress($shippingAddress)
            ->setCustomFields($customFields)
            ->setItemDetailFields($itemDetailFields)
            ->setStatusCode($statusCode)
            ->setItemCode($itemCode)
            ->setColor($color)
            ->setBrand($brand)
            ->setSize($size)
            ->setItemName($itemName)
            ->setShippingPackageCode($shippingPackageCode)
            ->setCancellable($cancellable)
            ->setCancellationReason($cancellationReason)
            ->setCreatedOn($createdOn)
            ->setUpdatedOn($updatedOn)
            ->setSaleOrderCode($saleOrderCode);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\SaleOrderItem
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get ItemSKU value
     * @return string|null
     */
    public function getItemSKU()
    {
        return $this->ItemSKU;
    }
    /**
     * Set ItemSKU value
     * @param string $itemSKU
     * @return \StructType\SaleOrderItem
     */
    public function setItemSKU($itemSKU = null)
    {
        // validation for constraint: string
        if (!is_null($itemSKU) && !is_string($itemSKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemSKU, true), gettype($itemSKU)), __LINE__);
        }
        $this->ItemSKU = $itemSKU;
        return $this;
    }
    /**
     * Get ChannelProductId value
     * @return string|null
     */
    public function getChannelProductId()
    {
        return $this->ChannelProductId;
    }
    /**
     * Set ChannelProductId value
     * @param string $channelProductId
     * @return \StructType\SaleOrderItem
     */
    public function setChannelProductId($channelProductId = null)
    {
        // validation for constraint: string
        if (!is_null($channelProductId) && !is_string($channelProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($channelProductId, true), gettype($channelProductId)), __LINE__);
        }
        $this->ChannelProductId = $channelProductId;
        return $this;
    }
    /**
     * Get ShippingMethodCode value
     * @return string|null
     */
    public function getShippingMethodCode()
    {
        return $this->ShippingMethodCode;
    }
    /**
     * Set ShippingMethodCode value
     * @param string $shippingMethodCode
     * @return \StructType\SaleOrderItem
     */
    public function setShippingMethodCode($shippingMethodCode = null)
    {
        // validation for constraint: string
        if (!is_null($shippingMethodCode) && !is_string($shippingMethodCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingMethodCode, true), gettype($shippingMethodCode)), __LINE__);
        }
        $this->ShippingMethodCode = $shippingMethodCode;
        return $this;
    }
    /**
     * Get GiftWrap value
     * @return bool|null
     */
    public function getGiftWrap()
    {
        return $this->GiftWrap;
    }
    /**
     * Set GiftWrap value
     * @param bool $giftWrap
     * @return \StructType\SaleOrderItem
     */
    public function setGiftWrap($giftWrap = null)
    {
        // validation for constraint: boolean
        if (!is_null($giftWrap) && !is_bool($giftWrap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($giftWrap, true), gettype($giftWrap)), __LINE__);
        }
        $this->GiftWrap = $giftWrap;
        return $this;
    }
    /**
     * Get GiftMessage value
     * @return string|null
     */
    public function getGiftMessage()
    {
        return $this->GiftMessage;
    }
    /**
     * Set GiftMessage value
     * @param string $giftMessage
     * @return \StructType\SaleOrderItem
     */
    public function setGiftMessage($giftMessage = null)
    {
        // validation for constraint: string
        if (!is_null($giftMessage) && !is_string($giftMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftMessage, true), gettype($giftMessage)), __LINE__);
        }
        $this->GiftMessage = $giftMessage;
        return $this;
    }
    /**
     * Get TotalPrice value
     * @return float|null
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param float $totalPrice
     * @return \StructType\SaleOrderItem
     */
    public function setTotalPrice($totalPrice = null)
    {
        // validation for constraint: float
        if (!is_null($totalPrice) && !(is_float($totalPrice) || is_numeric($totalPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPrice, true), gettype($totalPrice)), __LINE__);
        }
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get SellingPrice value
     * @return float|null
     */
    public function getSellingPrice()
    {
        return $this->SellingPrice;
    }
    /**
     * Set SellingPrice value
     * @param float $sellingPrice
     * @return \StructType\SaleOrderItem
     */
    public function setSellingPrice($sellingPrice = null)
    {
        // validation for constraint: float
        if (!is_null($sellingPrice) && !(is_float($sellingPrice) || is_numeric($sellingPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sellingPrice, true), gettype($sellingPrice)), __LINE__);
        }
        $this->SellingPrice = $sellingPrice;
        return $this;
    }
    /**
     * Get PrepaidAmount value
     * @return float|null
     */
    public function getPrepaidAmount()
    {
        return $this->PrepaidAmount;
    }
    /**
     * Set PrepaidAmount value
     * @param float $prepaidAmount
     * @return \StructType\SaleOrderItem
     */
    public function setPrepaidAmount($prepaidAmount = null)
    {
        // validation for constraint: float
        if (!is_null($prepaidAmount) && !(is_float($prepaidAmount) || is_numeric($prepaidAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prepaidAmount, true), gettype($prepaidAmount)), __LINE__);
        }
        $this->PrepaidAmount = $prepaidAmount;
        return $this;
    }
    /**
     * Get ShippingCharges value
     * @return float|null
     */
    public function getShippingCharges()
    {
        return $this->ShippingCharges;
    }
    /**
     * Set ShippingCharges value
     * @param float $shippingCharges
     * @return \StructType\SaleOrderItem
     */
    public function setShippingCharges($shippingCharges = null)
    {
        // validation for constraint: float
        if (!is_null($shippingCharges) && !(is_float($shippingCharges) || is_numeric($shippingCharges))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingCharges, true), gettype($shippingCharges)), __LINE__);
        }
        $this->ShippingCharges = $shippingCharges;
        return $this;
    }
    /**
     * Get ShippingMethodCharges value
     * @return float|null
     */
    public function getShippingMethodCharges()
    {
        return $this->ShippingMethodCharges;
    }
    /**
     * Set ShippingMethodCharges value
     * @param float $shippingMethodCharges
     * @return \StructType\SaleOrderItem
     */
    public function setShippingMethodCharges($shippingMethodCharges = null)
    {
        // validation for constraint: float
        if (!is_null($shippingMethodCharges) && !(is_float($shippingMethodCharges) || is_numeric($shippingMethodCharges))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingMethodCharges, true), gettype($shippingMethodCharges)), __LINE__);
        }
        $this->ShippingMethodCharges = $shippingMethodCharges;
        return $this;
    }
    /**
     * Get CashOnDeliveryCharges value
     * @return float|null
     */
    public function getCashOnDeliveryCharges()
    {
        return $this->CashOnDeliveryCharges;
    }
    /**
     * Set CashOnDeliveryCharges value
     * @param float $cashOnDeliveryCharges
     * @return \StructType\SaleOrderItem
     */
    public function setCashOnDeliveryCharges($cashOnDeliveryCharges = null)
    {
        // validation for constraint: float
        if (!is_null($cashOnDeliveryCharges) && !(is_float($cashOnDeliveryCharges) || is_numeric($cashOnDeliveryCharges))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cashOnDeliveryCharges, true), gettype($cashOnDeliveryCharges)), __LINE__);
        }
        $this->CashOnDeliveryCharges = $cashOnDeliveryCharges;
        return $this;
    }
    /**
     * Get Discount value
     * @return float|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param float $discount
     * @return \StructType\SaleOrderItem
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: float
        if (!is_null($discount) && !(is_float($discount) || is_numeric($discount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get GiftWrapCharges value
     * @return float|null
     */
    public function getGiftWrapCharges()
    {
        return $this->GiftWrapCharges;
    }
    /**
     * Set GiftWrapCharges value
     * @param float $giftWrapCharges
     * @return \StructType\SaleOrderItem
     */
    public function setGiftWrapCharges($giftWrapCharges = null)
    {
        // validation for constraint: float
        if (!is_null($giftWrapCharges) && !(is_float($giftWrapCharges) || is_numeric($giftWrapCharges))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($giftWrapCharges, true), gettype($giftWrapCharges)), __LINE__);
        }
        $this->GiftWrapCharges = $giftWrapCharges;
        return $this;
    }
    /**
     * Get VoucherCode value
     * @return string|null
     */
    public function getVoucherCode()
    {
        return $this->VoucherCode;
    }
    /**
     * Set VoucherCode value
     * @param string $voucherCode
     * @return \StructType\SaleOrderItem
     */
    public function setVoucherCode($voucherCode = null)
    {
        // validation for constraint: string
        if (!is_null($voucherCode) && !is_string($voucherCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherCode, true), gettype($voucherCode)), __LINE__);
        }
        $this->VoucherCode = $voucherCode;
        return $this;
    }
    /**
     * Get VoucherValue value
     * @return float|null
     */
    public function getVoucherValue()
    {
        return $this->VoucherValue;
    }
    /**
     * Set VoucherValue value
     * @param float $voucherValue
     * @return \StructType\SaleOrderItem
     */
    public function setVoucherValue($voucherValue = null)
    {
        // validation for constraint: float
        if (!is_null($voucherValue) && !(is_float($voucherValue) || is_numeric($voucherValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($voucherValue, true), gettype($voucherValue)), __LINE__);
        }
        $this->VoucherValue = $voucherValue;
        return $this;
    }
    /**
     * Get StoreCredit value
     * @return float|null
     */
    public function getStoreCredit()
    {
        return $this->StoreCredit;
    }
    /**
     * Set StoreCredit value
     * @param float $storeCredit
     * @return \StructType\SaleOrderItem
     */
    public function setStoreCredit($storeCredit = null)
    {
        // validation for constraint: float
        if (!is_null($storeCredit) && !(is_float($storeCredit) || is_numeric($storeCredit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($storeCredit, true), gettype($storeCredit)), __LINE__);
        }
        $this->StoreCredit = $storeCredit;
        return $this;
    }
    /**
     * Get PacketNumber value
     * @return int|null
     */
    public function getPacketNumber()
    {
        return $this->PacketNumber;
    }
    /**
     * Set PacketNumber value
     * @param int $packetNumber
     * @return \StructType\SaleOrderItem
     */
    public function setPacketNumber($packetNumber = null)
    {
        // validation for constraint: int
        if (!is_null($packetNumber) && !(is_int($packetNumber) || ctype_digit($packetNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packetNumber, true), gettype($packetNumber)), __LINE__);
        }
        $this->PacketNumber = $packetNumber;
        return $this;
    }
    /**
     * Get CombinationIdentifier value
     * @return string|null
     */
    public function getCombinationIdentifier()
    {
        return $this->CombinationIdentifier;
    }
    /**
     * Set CombinationIdentifier value
     * @param string $combinationIdentifier
     * @return \StructType\SaleOrderItem
     */
    public function setCombinationIdentifier($combinationIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($combinationIdentifier) && !is_string($combinationIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($combinationIdentifier, true), gettype($combinationIdentifier)), __LINE__);
        }
        $this->CombinationIdentifier = $combinationIdentifier;
        return $this;
    }
    /**
     * Get OnHold value
     * @return bool|null
     */
    public function getOnHold()
    {
        return $this->OnHold;
    }
    /**
     * Set OnHold value
     * @param bool $onHold
     * @return \StructType\SaleOrderItem
     */
    public function setOnHold($onHold = null)
    {
        // validation for constraint: boolean
        if (!is_null($onHold) && !is_bool($onHold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onHold, true), gettype($onHold)), __LINE__);
        }
        $this->OnHold = $onHold;
        return $this;
    }
    /**
     * Get FacilityCode value
     * @return string|null
     */
    public function getFacilityCode()
    {
        return $this->FacilityCode;
    }
    /**
     * Set FacilityCode value
     * @param string $facilityCode
     * @return \StructType\SaleOrderItem
     */
    public function setFacilityCode($facilityCode = null)
    {
        // validation for constraint: string
        if (!is_null($facilityCode) && !is_string($facilityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($facilityCode, true), gettype($facilityCode)), __LINE__);
        }
        $this->FacilityCode = $facilityCode;
        return $this;
    }
    /**
     * Get RequiresCustomization value
     * @return bool|null
     */
    public function getRequiresCustomization()
    {
        return $this->RequiresCustomization;
    }
    /**
     * Set RequiresCustomization value
     * @param bool $requiresCustomization
     * @return \StructType\SaleOrderItem
     */
    public function setRequiresCustomization($requiresCustomization = null)
    {
        // validation for constraint: boolean
        if (!is_null($requiresCustomization) && !is_bool($requiresCustomization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($requiresCustomization, true), gettype($requiresCustomization)), __LINE__);
        }
        $this->RequiresCustomization = $requiresCustomization;
        return $this;
    }
    /**
     * Get ShippingAddress value
     * @return \StructType\AddressRef|null
     */
    public function getShippingAddress()
    {
        return $this->ShippingAddress;
    }
    /**
     * Set ShippingAddress value
     * @param \StructType\AddressRef $shippingAddress
     * @return \StructType\SaleOrderItem
     */
    public function setShippingAddress(\StructType\AddressRef $shippingAddress = null)
    {
        $this->ShippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \StructType\CustomFields|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \StructType\CustomFields $customFields
     * @return \StructType\SaleOrderItem
     */
    public function setCustomFields(\StructType\CustomFields $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Get ItemDetailFields value
     * @return \StructType\ItemDetailFields|null
     */
    public function getItemDetailFields()
    {
        return $this->ItemDetailFields;
    }
    /**
     * Set ItemDetailFields value
     * @param \StructType\ItemDetailFields $itemDetailFields
     * @return \StructType\SaleOrderItem
     */
    public function setItemDetailFields(\StructType\ItemDetailFields $itemDetailFields = null)
    {
        $this->ItemDetailFields = $itemDetailFields;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\SaleOrderItem
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get ItemCode value
     * @return string|null
     */
    public function getItemCode()
    {
        return $this->ItemCode;
    }
    /**
     * Set ItemCode value
     * @param string $itemCode
     * @return \StructType\SaleOrderItem
     */
    public function setItemCode($itemCode = null)
    {
        // validation for constraint: string
        if (!is_null($itemCode) && !is_string($itemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemCode, true), gettype($itemCode)), __LINE__);
        }
        $this->ItemCode = $itemCode;
        return $this;
    }
    /**
     * Get Color value
     * @return string|null
     */
    public function getColor()
    {
        return $this->Color;
    }
    /**
     * Set Color value
     * @param string $color
     * @return \StructType\SaleOrderItem
     */
    public function setColor($color = null)
    {
        // validation for constraint: string
        if (!is_null($color) && !is_string($color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($color, true), gettype($color)), __LINE__);
        }
        $this->Color = $color;
        return $this;
    }
    /**
     * Get Brand value
     * @return string|null
     */
    public function getBrand()
    {
        return $this->Brand;
    }
    /**
     * Set Brand value
     * @param string $brand
     * @return \StructType\SaleOrderItem
     */
    public function setBrand($brand = null)
    {
        // validation for constraint: string
        if (!is_null($brand) && !is_string($brand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brand, true), gettype($brand)), __LINE__);
        }
        $this->Brand = $brand;
        return $this;
    }
    /**
     * Get Size value
     * @return string|null
     */
    public function getSize()
    {
        return $this->Size;
    }
    /**
     * Set Size value
     * @param string $size
     * @return \StructType\SaleOrderItem
     */
    public function setSize($size = null)
    {
        // validation for constraint: string
        if (!is_null($size) && !is_string($size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($size, true), gettype($size)), __LINE__);
        }
        $this->Size = $size;
        return $this;
    }
    /**
     * Get ItemName value
     * @return string|null
     */
    public function getItemName()
    {
        return $this->ItemName;
    }
    /**
     * Set ItemName value
     * @param string $itemName
     * @return \StructType\SaleOrderItem
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemName, true), gettype($itemName)), __LINE__);
        }
        $this->ItemName = $itemName;
        return $this;
    }
    /**
     * Get ShippingPackageCode value
     * @return string|null
     */
    public function getShippingPackageCode()
    {
        return $this->ShippingPackageCode;
    }
    /**
     * Set ShippingPackageCode value
     * @param string $shippingPackageCode
     * @return \StructType\SaleOrderItem
     */
    public function setShippingPackageCode($shippingPackageCode = null)
    {
        // validation for constraint: string
        if (!is_null($shippingPackageCode) && !is_string($shippingPackageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingPackageCode, true), gettype($shippingPackageCode)), __LINE__);
        }
        $this->ShippingPackageCode = $shippingPackageCode;
        return $this;
    }
    /**
     * Get Cancellable value
     * @return bool|null
     */
    public function getCancellable()
    {
        return $this->Cancellable;
    }
    /**
     * Set Cancellable value
     * @param bool $cancellable
     * @return \StructType\SaleOrderItem
     */
    public function setCancellable($cancellable = null)
    {
        // validation for constraint: boolean
        if (!is_null($cancellable) && !is_bool($cancellable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cancellable, true), gettype($cancellable)), __LINE__);
        }
        $this->Cancellable = $cancellable;
        return $this;
    }
    /**
     * Get CancellationReason value
     * @return string|null
     */
    public function getCancellationReason()
    {
        return $this->CancellationReason;
    }
    /**
     * Set CancellationReason value
     * @param string $cancellationReason
     * @return \StructType\SaleOrderItem
     */
    public function setCancellationReason($cancellationReason = null)
    {
        // validation for constraint: string
        if (!is_null($cancellationReason) && !is_string($cancellationReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancellationReason, true), gettype($cancellationReason)), __LINE__);
        }
        $this->CancellationReason = $cancellationReason;
        return $this;
    }
    /**
     * Get CreatedOn value
     * @return string|null
     */
    public function getCreatedOn()
    {
        return $this->CreatedOn;
    }
    /**
     * Set CreatedOn value
     * @param string $createdOn
     * @return \StructType\SaleOrderItem
     */
    public function setCreatedOn($createdOn = null)
    {
        // validation for constraint: string
        if (!is_null($createdOn) && !is_string($createdOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdOn, true), gettype($createdOn)), __LINE__);
        }
        $this->CreatedOn = $createdOn;
        return $this;
    }
    /**
     * Get UpdatedOn value
     * @return string|null
     */
    public function getUpdatedOn()
    {
        return $this->UpdatedOn;
    }
    /**
     * Set UpdatedOn value
     * @param string $updatedOn
     * @return \StructType\SaleOrderItem
     */
    public function setUpdatedOn($updatedOn = null)
    {
        // validation for constraint: string
        if (!is_null($updatedOn) && !is_string($updatedOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updatedOn, true), gettype($updatedOn)), __LINE__);
        }
        $this->UpdatedOn = $updatedOn;
        return $this;
    }
    /**
     * Get SaleOrderCode value
     * @return string|null
     */
    public function getSaleOrderCode()
    {
        return $this->SaleOrderCode;
    }
    /**
     * Set SaleOrderCode value
     * @param string $saleOrderCode
     * @return \StructType\SaleOrderItem
     */
    public function setSaleOrderCode($saleOrderCode = null)
    {
        // validation for constraint: string
        if (!is_null($saleOrderCode) && !is_string($saleOrderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleOrderCode, true), gettype($saleOrderCode)), __LINE__);
        }
        $this->SaleOrderCode = $saleOrderCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SaleOrderItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
