<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaleOrder StructType
 * @subpackage Structs
 */
class SaleOrder extends AbstractStructBase
{
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The DisplayOrderCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DisplayOrderCode;
    /**
     * The DisplayOrderDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DisplayOrderDateTime;
    /**
     * The Channel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Channel;
    /**
     * The NotificationEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NotificationEmail;
    /**
     * The NotificationMobile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NotificationMobile;
    /**
     * The CashOnDelivery
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CashOnDelivery;
    /**
     * The AdditionalInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AdditionalInfo;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * The CustomerCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CustomerCode;
    /**
     * The TaxExempted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $TaxExempted;
    /**
     * The CFormProvided
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CFormProvided;
    /**
     * The FulfillmentTat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FulfillmentTat;
    /**
     * The Addresses
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Addresses
     */
    public $Addresses;
    /**
     * The ShippingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AddressRef
     */
    public $ShippingAddress;
    /**
     * The BillingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AddressRef
     */
    public $BillingAddress;
    /**
     * The SaleOrderItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SaleOrderItems
     */
    public $SaleOrderItems;
    /**
     * The ShippingProviders
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ShippingProviders
     */
    public $ShippingProviders;
    /**
     * The SaleOrderItemCombinations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SaleOrderItemCombinations
     */
    public $SaleOrderItemCombinations;
    /**
     * The CustomFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFields
     */
    public $CustomFields;
    /**
     * The VerificationRequired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $VerificationRequired;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Priority;
    /**
     * The CancellationReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CancellationReason;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The CreatedOn
     * @var string
     */
    public $CreatedOn;
    /**
     * The UpdatedOn
     * @var string
     */
    public $UpdatedOn;
    /**
     * The ShippingPackages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ShippingPackages
     */
    public $ShippingPackages;
    /**
     * Constructor method for SaleOrder
     * @uses SaleOrder::setCode()
     * @uses SaleOrder::setDisplayOrderCode()
     * @uses SaleOrder::setDisplayOrderDateTime()
     * @uses SaleOrder::setChannel()
     * @uses SaleOrder::setNotificationEmail()
     * @uses SaleOrder::setNotificationMobile()
     * @uses SaleOrder::setCashOnDelivery()
     * @uses SaleOrder::setAdditionalInfo()
     * @uses SaleOrder::setCurrencyCode()
     * @uses SaleOrder::setCustomerCode()
     * @uses SaleOrder::setTaxExempted()
     * @uses SaleOrder::setCFormProvided()
     * @uses SaleOrder::setFulfillmentTat()
     * @uses SaleOrder::setAddresses()
     * @uses SaleOrder::setShippingAddress()
     * @uses SaleOrder::setBillingAddress()
     * @uses SaleOrder::setSaleOrderItems()
     * @uses SaleOrder::setShippingProviders()
     * @uses SaleOrder::setSaleOrderItemCombinations()
     * @uses SaleOrder::setCustomFields()
     * @uses SaleOrder::setVerificationRequired()
     * @uses SaleOrder::setPriority()
     * @uses SaleOrder::setCancellationReason()
     * @uses SaleOrder::setStatus()
     * @uses SaleOrder::setCreatedOn()
     * @uses SaleOrder::setUpdatedOn()
     * @uses SaleOrder::setShippingPackages()
     * @param string $code
     * @param string $displayOrderCode
     * @param string $displayOrderDateTime
     * @param string $channel
     * @param string $notificationEmail
     * @param string $notificationMobile
     * @param bool $cashOnDelivery
     * @param string $additionalInfo
     * @param string $currencyCode
     * @param string $customerCode
     * @param bool $taxExempted
     * @param bool $cFormProvided
     * @param string $fulfillmentTat
     * @param \StructType\Addresses $addresses
     * @param \StructType\AddressRef $shippingAddress
     * @param \StructType\AddressRef $billingAddress
     * @param \StructType\SaleOrderItems $saleOrderItems
     * @param \StructType\ShippingProviders $shippingProviders
     * @param \StructType\SaleOrderItemCombinations $saleOrderItemCombinations
     * @param \StructType\CustomFields $customFields
     * @param bool $verificationRequired
     * @param int $priority
     * @param string $cancellationReason
     * @param string $status
     * @param string $createdOn
     * @param string $updatedOn
     * @param \StructType\ShippingPackages $shippingPackages
     */
    public function __construct($code = null, $displayOrderCode = null, $displayOrderDateTime = null, $channel = null, $notificationEmail = null, $notificationMobile = null, $cashOnDelivery = null, $additionalInfo = null, $currencyCode = null, $customerCode = null, $taxExempted = null, $cFormProvided = null, $fulfillmentTat = null, \StructType\Addresses $addresses = null, \StructType\AddressRef $shippingAddress = null, \StructType\AddressRef $billingAddress = null, \StructType\SaleOrderItems $saleOrderItems = null, \StructType\ShippingProviders $shippingProviders = null, \StructType\SaleOrderItemCombinations $saleOrderItemCombinations = null, \StructType\CustomFields $customFields = null, $verificationRequired = null, $priority = null, $cancellationReason = null, $status = null, $createdOn = null, $updatedOn = null, \StructType\ShippingPackages $shippingPackages = null)
    {
        $this
            ->setCode($code)
            ->setDisplayOrderCode($displayOrderCode)
            ->setDisplayOrderDateTime($displayOrderDateTime)
            ->setChannel($channel)
            ->setNotificationEmail($notificationEmail)
            ->setNotificationMobile($notificationMobile)
            ->setCashOnDelivery($cashOnDelivery)
            ->setAdditionalInfo($additionalInfo)
            ->setCurrencyCode($currencyCode)
            ->setCustomerCode($customerCode)
            ->setTaxExempted($taxExempted)
            ->setCFormProvided($cFormProvided)
            ->setFulfillmentTat($fulfillmentTat)
            ->setAddresses($addresses)
            ->setShippingAddress($shippingAddress)
            ->setBillingAddress($billingAddress)
            ->setSaleOrderItems($saleOrderItems)
            ->setShippingProviders($shippingProviders)
            ->setSaleOrderItemCombinations($saleOrderItemCombinations)
            ->setCustomFields($customFields)
            ->setVerificationRequired($verificationRequired)
            ->setPriority($priority)
            ->setCancellationReason($cancellationReason)
            ->setStatus($status)
            ->setCreatedOn($createdOn)
            ->setUpdatedOn($updatedOn)
            ->setShippingPackages($shippingPackages);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\SaleOrder
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get DisplayOrderCode value
     * @return string|null
     */
    public function getDisplayOrderCode()
    {
        return $this->DisplayOrderCode;
    }
    /**
     * Set DisplayOrderCode value
     * @param string $displayOrderCode
     * @return \StructType\SaleOrder
     */
    public function setDisplayOrderCode($displayOrderCode = null)
    {
        // validation for constraint: string
        if (!is_null($displayOrderCode) && !is_string($displayOrderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayOrderCode, true), gettype($displayOrderCode)), __LINE__);
        }
        $this->DisplayOrderCode = $displayOrderCode;
        return $this;
    }
    /**
     * Get DisplayOrderDateTime value
     * @return string|null
     */
    public function getDisplayOrderDateTime()
    {
        return $this->DisplayOrderDateTime;
    }
    /**
     * Set DisplayOrderDateTime value
     * @param string $displayOrderDateTime
     * @return \StructType\SaleOrder
     */
    public function setDisplayOrderDateTime($displayOrderDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($displayOrderDateTime) && !is_string($displayOrderDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayOrderDateTime, true), gettype($displayOrderDateTime)), __LINE__);
        }
        $this->DisplayOrderDateTime = $displayOrderDateTime;
        return $this;
    }
    /**
     * Get Channel value
     * @return string|null
     */
    public function getChannel()
    {
        return $this->Channel;
    }
    /**
     * Set Channel value
     * @param string $channel
     * @return \StructType\SaleOrder
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: string
        if (!is_null($channel) && !is_string($channel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($channel, true), gettype($channel)), __LINE__);
        }
        $this->Channel = $channel;
        return $this;
    }
    /**
     * Get NotificationEmail value
     * @return string|null
     */
    public function getNotificationEmail()
    {
        return $this->NotificationEmail;
    }
    /**
     * Set NotificationEmail value
     * @param string $notificationEmail
     * @return \StructType\SaleOrder
     */
    public function setNotificationEmail($notificationEmail = null)
    {
        // validation for constraint: string
        if (!is_null($notificationEmail) && !is_string($notificationEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notificationEmail, true), gettype($notificationEmail)), __LINE__);
        }
        $this->NotificationEmail = $notificationEmail;
        return $this;
    }
    /**
     * Get NotificationMobile value
     * @return string|null
     */
    public function getNotificationMobile()
    {
        return $this->NotificationMobile;
    }
    /**
     * Set NotificationMobile value
     * @param string $notificationMobile
     * @return \StructType\SaleOrder
     */
    public function setNotificationMobile($notificationMobile = null)
    {
        // validation for constraint: string
        if (!is_null($notificationMobile) && !is_string($notificationMobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notificationMobile, true), gettype($notificationMobile)), __LINE__);
        }
        $this->NotificationMobile = $notificationMobile;
        return $this;
    }
    /**
     * Get CashOnDelivery value
     * @return bool|null
     */
    public function getCashOnDelivery()
    {
        return $this->CashOnDelivery;
    }
    /**
     * Set CashOnDelivery value
     * @param bool $cashOnDelivery
     * @return \StructType\SaleOrder
     */
    public function setCashOnDelivery($cashOnDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($cashOnDelivery) && !is_bool($cashOnDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cashOnDelivery, true), gettype($cashOnDelivery)), __LINE__);
        }
        $this->CashOnDelivery = $cashOnDelivery;
        return $this;
    }
    /**
     * Get AdditionalInfo value
     * @return string|null
     */
    public function getAdditionalInfo()
    {
        return $this->AdditionalInfo;
    }
    /**
     * Set AdditionalInfo value
     * @param string $additionalInfo
     * @return \StructType\SaleOrder
     */
    public function setAdditionalInfo($additionalInfo = null)
    {
        // validation for constraint: string
        if (!is_null($additionalInfo) && !is_string($additionalInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalInfo, true), gettype($additionalInfo)), __LINE__);
        }
        $this->AdditionalInfo = $additionalInfo;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\SaleOrder
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get CustomerCode value
     * @return string|null
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }
    /**
     * Set CustomerCode value
     * @param string $customerCode
     * @return \StructType\SaleOrder
     */
    public function setCustomerCode($customerCode = null)
    {
        // validation for constraint: string
        if (!is_null($customerCode) && !is_string($customerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerCode, true), gettype($customerCode)), __LINE__);
        }
        $this->CustomerCode = $customerCode;
        return $this;
    }
    /**
     * Get TaxExempted value
     * @return bool|null
     */
    public function getTaxExempted()
    {
        return $this->TaxExempted;
    }
    /**
     * Set TaxExempted value
     * @param bool $taxExempted
     * @return \StructType\SaleOrder
     */
    public function setTaxExempted($taxExempted = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxExempted) && !is_bool($taxExempted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxExempted, true), gettype($taxExempted)), __LINE__);
        }
        $this->TaxExempted = $taxExempted;
        return $this;
    }
    /**
     * Get CFormProvided value
     * @return bool|null
     */
    public function getCFormProvided()
    {
        return $this->CFormProvided;
    }
    /**
     * Set CFormProvided value
     * @param bool $cFormProvided
     * @return \StructType\SaleOrder
     */
    public function setCFormProvided($cFormProvided = null)
    {
        // validation for constraint: boolean
        if (!is_null($cFormProvided) && !is_bool($cFormProvided)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cFormProvided, true), gettype($cFormProvided)), __LINE__);
        }
        $this->CFormProvided = $cFormProvided;
        return $this;
    }
    /**
     * Get FulfillmentTat value
     * @return string|null
     */
    public function getFulfillmentTat()
    {
        return $this->FulfillmentTat;
    }
    /**
     * Set FulfillmentTat value
     * @param string $fulfillmentTat
     * @return \StructType\SaleOrder
     */
    public function setFulfillmentTat($fulfillmentTat = null)
    {
        // validation for constraint: string
        if (!is_null($fulfillmentTat) && !is_string($fulfillmentTat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fulfillmentTat, true), gettype($fulfillmentTat)), __LINE__);
        }
        $this->FulfillmentTat = $fulfillmentTat;
        return $this;
    }
    /**
     * Get Addresses value
     * @return \StructType\Addresses|null
     */
    public function getAddresses()
    {
        return $this->Addresses;
    }
    /**
     * Set Addresses value
     * @param \StructType\Addresses $addresses
     * @return \StructType\SaleOrder
     */
    public function setAddresses(\StructType\Addresses $addresses = null)
    {
        $this->Addresses = $addresses;
        return $this;
    }
    /**
     * Get ShippingAddress value
     * @return \StructType\AddressRef|null
     */
    public function getShippingAddress()
    {
        return $this->ShippingAddress;
    }
    /**
     * Set ShippingAddress value
     * @param \StructType\AddressRef $shippingAddress
     * @return \StructType\SaleOrder
     */
    public function setShippingAddress(\StructType\AddressRef $shippingAddress = null)
    {
        $this->ShippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Get BillingAddress value
     * @return \StructType\AddressRef|null
     */
    public function getBillingAddress()
    {
        return $this->BillingAddress;
    }
    /**
     * Set BillingAddress value
     * @param \StructType\AddressRef $billingAddress
     * @return \StructType\SaleOrder
     */
    public function setBillingAddress(\StructType\AddressRef $billingAddress = null)
    {
        $this->BillingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get SaleOrderItems value
     * @return \StructType\SaleOrderItems|null
     */
    public function getSaleOrderItems()
    {
        return $this->SaleOrderItems;
    }
    /**
     * Set SaleOrderItems value
     * @param \StructType\SaleOrderItems $saleOrderItems
     * @return \StructType\SaleOrder
     */
    public function setSaleOrderItems(\StructType\SaleOrderItems $saleOrderItems = null)
    {
        $this->SaleOrderItems = $saleOrderItems;
        return $this;
    }
    /**
     * Get ShippingProviders value
     * @return \StructType\ShippingProviders|null
     */
    public function getShippingProviders()
    {
        return $this->ShippingProviders;
    }
    /**
     * Set ShippingProviders value
     * @param \StructType\ShippingProviders $shippingProviders
     * @return \StructType\SaleOrder
     */
    public function setShippingProviders(\StructType\ShippingProviders $shippingProviders = null)
    {
        $this->ShippingProviders = $shippingProviders;
        return $this;
    }
    /**
     * Get SaleOrderItemCombinations value
     * @return \StructType\SaleOrderItemCombinations|null
     */
    public function getSaleOrderItemCombinations()
    {
        return $this->SaleOrderItemCombinations;
    }
    /**
     * Set SaleOrderItemCombinations value
     * @param \StructType\SaleOrderItemCombinations $saleOrderItemCombinations
     * @return \StructType\SaleOrder
     */
    public function setSaleOrderItemCombinations(\StructType\SaleOrderItemCombinations $saleOrderItemCombinations = null)
    {
        $this->SaleOrderItemCombinations = $saleOrderItemCombinations;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \StructType\CustomFields|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \StructType\CustomFields $customFields
     * @return \StructType\SaleOrder
     */
    public function setCustomFields(\StructType\CustomFields $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Get VerificationRequired value
     * @return bool|null
     */
    public function getVerificationRequired()
    {
        return $this->VerificationRequired;
    }
    /**
     * Set VerificationRequired value
     * @param bool $verificationRequired
     * @return \StructType\SaleOrder
     */
    public function setVerificationRequired($verificationRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($verificationRequired) && !is_bool($verificationRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($verificationRequired, true), gettype($verificationRequired)), __LINE__);
        }
        $this->VerificationRequired = $verificationRequired;
        return $this;
    }
    /**
     * Get Priority value
     * @return int|null
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param int $priority
     * @return \StructType\SaleOrder
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get CancellationReason value
     * @return string|null
     */
    public function getCancellationReason()
    {
        return $this->CancellationReason;
    }
    /**
     * Set CancellationReason value
     * @param string $cancellationReason
     * @return \StructType\SaleOrder
     */
    public function setCancellationReason($cancellationReason = null)
    {
        // validation for constraint: string
        if (!is_null($cancellationReason) && !is_string($cancellationReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancellationReason, true), gettype($cancellationReason)), __LINE__);
        }
        $this->CancellationReason = $cancellationReason;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\SaleOrder
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get CreatedOn value
     * @return string|null
     */
    public function getCreatedOn()
    {
        return $this->CreatedOn;
    }
    /**
     * Set CreatedOn value
     * @param string $createdOn
     * @return \StructType\SaleOrder
     */
    public function setCreatedOn($createdOn = null)
    {
        // validation for constraint: string
        if (!is_null($createdOn) && !is_string($createdOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdOn, true), gettype($createdOn)), __LINE__);
        }
        $this->CreatedOn = $createdOn;
        return $this;
    }
    /**
     * Get UpdatedOn value
     * @return string|null
     */
    public function getUpdatedOn()
    {
        return $this->UpdatedOn;
    }
    /**
     * Set UpdatedOn value
     * @param string $updatedOn
     * @return \StructType\SaleOrder
     */
    public function setUpdatedOn($updatedOn = null)
    {
        // validation for constraint: string
        if (!is_null($updatedOn) && !is_string($updatedOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updatedOn, true), gettype($updatedOn)), __LINE__);
        }
        $this->UpdatedOn = $updatedOn;
        return $this;
    }
    /**
     * Get ShippingPackages value
     * @return \StructType\ShippingPackages|null
     */
    public function getShippingPackages()
    {
        return $this->ShippingPackages;
    }
    /**
     * Set ShippingPackages value
     * @param \StructType\ShippingPackages $shippingPackages
     * @return \StructType\SaleOrder
     */
    public function setShippingPackages(\StructType\ShippingPackages $shippingPackages = null)
    {
        $this->ShippingPackages = $shippingPackages;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SaleOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
