<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReversePickupItem StructType
 * @subpackage Structs
 */
class ReversePickupItem extends AbstractStructBase
{
    /**
     * The SaleOrderItemCode
     * @var string
     */
    public $SaleOrderItemCode;
    /**
     * The Reason
     * @var string
     */
    public $Reason;
    /**
     * The ReversePickupAlternate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReversePickupAlternate
     */
    public $ReversePickupAlternate;
    /**
     * Constructor method for ReversePickupItem
     * @uses ReversePickupItem::setSaleOrderItemCode()
     * @uses ReversePickupItem::setReason()
     * @uses ReversePickupItem::setReversePickupAlternate()
     * @param string $saleOrderItemCode
     * @param string $reason
     * @param \StructType\ReversePickupAlternate $reversePickupAlternate
     */
    public function __construct($saleOrderItemCode = null, $reason = null, \StructType\ReversePickupAlternate $reversePickupAlternate = null)
    {
        $this
            ->setSaleOrderItemCode($saleOrderItemCode)
            ->setReason($reason)
            ->setReversePickupAlternate($reversePickupAlternate);
    }
    /**
     * Get SaleOrderItemCode value
     * @return string|null
     */
    public function getSaleOrderItemCode()
    {
        return $this->SaleOrderItemCode;
    }
    /**
     * Set SaleOrderItemCode value
     * @param string $saleOrderItemCode
     * @return \StructType\ReversePickupItem
     */
    public function setSaleOrderItemCode($saleOrderItemCode = null)
    {
        // validation for constraint: string
        if (!is_null($saleOrderItemCode) && !is_string($saleOrderItemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleOrderItemCode, true), gettype($saleOrderItemCode)), __LINE__);
        }
        $this->SaleOrderItemCode = $saleOrderItemCode;
        return $this;
    }
    /**
     * Get Reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param string $reason
     * @return \StructType\ReversePickupItem
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Get ReversePickupAlternate value
     * @return \StructType\ReversePickupAlternate|null
     */
    public function getReversePickupAlternate()
    {
        return $this->ReversePickupAlternate;
    }
    /**
     * Set ReversePickupAlternate value
     * @param \StructType\ReversePickupAlternate $reversePickupAlternate
     * @return \StructType\ReversePickupItem
     */
    public function setReversePickupAlternate(\StructType\ReversePickupAlternate $reversePickupAlternate = null)
    {
        $this->ReversePickupAlternate = $reversePickupAlternate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReversePickupItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
