<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModifyPacketSaleOrderRequest StructType
 * @subpackage Structs
 */
class ModifyPacketSaleOrderRequest extends AbstractStructBase
{
    /**
     * The SaleOrderCode
     * @var string
     */
    public $SaleOrderCode;
    /**
     * The SaleOrderItemCodes
     * @var \StructType\SaleOrderItemCodes
     */
    public $SaleOrderItemCodes;
    /**
     * Constructor method for ModifyPacketSaleOrderRequest
     * @uses ModifyPacketSaleOrderRequest::setSaleOrderCode()
     * @uses ModifyPacketSaleOrderRequest::setSaleOrderItemCodes()
     * @param string $saleOrderCode
     * @param \StructType\SaleOrderItemCodes $saleOrderItemCodes
     */
    public function __construct($saleOrderCode = null, \StructType\SaleOrderItemCodes $saleOrderItemCodes = null)
    {
        $this
            ->setSaleOrderCode($saleOrderCode)
            ->setSaleOrderItemCodes($saleOrderItemCodes);
    }
    /**
     * Get SaleOrderCode value
     * @return string|null
     */
    public function getSaleOrderCode()
    {
        return $this->SaleOrderCode;
    }
    /**
     * Set SaleOrderCode value
     * @param string $saleOrderCode
     * @return \StructType\ModifyPacketSaleOrderRequest
     */
    public function setSaleOrderCode($saleOrderCode = null)
    {
        // validation for constraint: string
        if (!is_null($saleOrderCode) && !is_string($saleOrderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleOrderCode, true), gettype($saleOrderCode)), __LINE__);
        }
        $this->SaleOrderCode = $saleOrderCode;
        return $this;
    }
    /**
     * Get SaleOrderItemCodes value
     * @return \StructType\SaleOrderItemCodes|null
     */
    public function getSaleOrderItemCodes()
    {
        return $this->SaleOrderItemCodes;
    }
    /**
     * Set SaleOrderItemCodes value
     * @param \StructType\SaleOrderItemCodes $saleOrderItemCodes
     * @return \StructType\ModifyPacketSaleOrderRequest
     */
    public function setSaleOrderItemCodes(\StructType\SaleOrderItemCodes $saleOrderItemCodes = null)
    {
        $this->SaleOrderItemCodes = $saleOrderItemCodes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ModifyPacketSaleOrderRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
