<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Facilities StructType
 * @subpackage Structs
 */
class Facilities extends AbstractStructBase
{
    /**
     * The Facility
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Facility[]
     */
    public $Facility;
    /**
     * Constructor method for Facilities
     * @uses Facilities::setFacility()
     * @param \StructType\Facility[] $facility
     */
    public function __construct(array $facility = array())
    {
        $this
            ->setFacility($facility);
    }
    /**
     * Get Facility value
     * @return \StructType\Facility[]|null
     */
    public function getFacility()
    {
        return $this->Facility;
    }
    /**
     * This method is responsible for validating the values passed to the setFacility method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFacility method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFacilityForArrayConstraintsFromSetFacility(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $facilitiesFacilityItem) {
            // validation for constraint: itemType
            if (!$facilitiesFacilityItem instanceof \StructType\Facility) {
                $invalidValues[] = is_object($facilitiesFacilityItem) ? get_class($facilitiesFacilityItem) : sprintf('%s(%s)', gettype($facilitiesFacilityItem), var_export($facilitiesFacilityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Facility property can only contain items of type \StructType\Facility, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Facility value
     * @throws \InvalidArgumentException
     * @param \StructType\Facility[] $facility
     * @return \StructType\Facilities
     */
    public function setFacility(array $facility = array())
    {
        // validation for constraint: array
        if ('' !== ($facilityArrayErrorMessage = self::validateFacilityForArrayConstraintsFromSetFacility($facility))) {
            throw new \InvalidArgumentException($facilityArrayErrorMessage, __LINE__);
        }
        $this->Facility = $facility;
        return $this;
    }
    /**
     * Add item to Facility value
     * @throws \InvalidArgumentException
     * @param \StructType\Facility $item
     * @return \StructType\Facilities
     */
    public function addToFacility(\StructType\Facility $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Facility) {
            throw new \InvalidArgumentException(sprintf('The Facility property can only contain items of type \StructType\Facility, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Facility[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Facilities
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
