<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditSaleOrderItemMetadataRequest StructType
 * @subpackage Structs
 */
class EditSaleOrderItemMetadataRequest extends AbstractStructBase
{
    /**
     * The SaleOrderCode
     * @var string
     */
    public $SaleOrderCode;
    /**
     * The SaleOrderItemCode
     * @var string
     */
    public $SaleOrderItemCode;
    /**
     * The CustomFields
     * @var \StructType\CustomFields
     */
    public $CustomFields;
    /**
     * Constructor method for EditSaleOrderItemMetadataRequest
     * @uses EditSaleOrderItemMetadataRequest::setSaleOrderCode()
     * @uses EditSaleOrderItemMetadataRequest::setSaleOrderItemCode()
     * @uses EditSaleOrderItemMetadataRequest::setCustomFields()
     * @param string $saleOrderCode
     * @param string $saleOrderItemCode
     * @param \StructType\CustomFields $customFields
     */
    public function __construct($saleOrderCode = null, $saleOrderItemCode = null, \StructType\CustomFields $customFields = null)
    {
        $this
            ->setSaleOrderCode($saleOrderCode)
            ->setSaleOrderItemCode($saleOrderItemCode)
            ->setCustomFields($customFields);
    }
    /**
     * Get SaleOrderCode value
     * @return string|null
     */
    public function getSaleOrderCode()
    {
        return $this->SaleOrderCode;
    }
    /**
     * Set SaleOrderCode value
     * @param string $saleOrderCode
     * @return \StructType\EditSaleOrderItemMetadataRequest
     */
    public function setSaleOrderCode($saleOrderCode = null)
    {
        // validation for constraint: string
        if (!is_null($saleOrderCode) && !is_string($saleOrderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleOrderCode, true), gettype($saleOrderCode)), __LINE__);
        }
        $this->SaleOrderCode = $saleOrderCode;
        return $this;
    }
    /**
     * Get SaleOrderItemCode value
     * @return string|null
     */
    public function getSaleOrderItemCode()
    {
        return $this->SaleOrderItemCode;
    }
    /**
     * Set SaleOrderItemCode value
     * @param string $saleOrderItemCode
     * @return \StructType\EditSaleOrderItemMetadataRequest
     */
    public function setSaleOrderItemCode($saleOrderItemCode = null)
    {
        // validation for constraint: string
        if (!is_null($saleOrderItemCode) && !is_string($saleOrderItemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleOrderItemCode, true), gettype($saleOrderItemCode)), __LINE__);
        }
        $this->SaleOrderItemCode = $saleOrderItemCode;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \StructType\CustomFields|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \StructType\CustomFields $customFields
     * @return \StructType\EditSaleOrderItemMetadataRequest
     */
    public function setCustomFields(\StructType\CustomFields $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EditSaleOrderItemMetadataRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
