<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateReversePickupRequest StructType
 * @subpackage Structs
 */
class CreateReversePickupRequest extends AbstractStructBase
{
    /**
     * The SaleOrderCode
     * @var string
     */
    public $SaleOrderCode;
    /**
     * The ReversePickupItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReversePickupItems
     */
    public $ReversePickupItems;
    /**
     * The Address
     * @var \StructType\Address
     */
    public $Address;
    /**
     * The ActionCode
     * @var string
     */
    public $ActionCode;
    /**
     * The CustomFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFields
     */
    public $CustomFields;
    /**
     * Constructor method for CreateReversePickupRequest
     * @uses CreateReversePickupRequest::setSaleOrderCode()
     * @uses CreateReversePickupRequest::setReversePickupItems()
     * @uses CreateReversePickupRequest::setAddress()
     * @uses CreateReversePickupRequest::setActionCode()
     * @uses CreateReversePickupRequest::setCustomFields()
     * @param string $saleOrderCode
     * @param \StructType\ReversePickupItems $reversePickupItems
     * @param \StructType\Address $address
     * @param string $actionCode
     * @param \StructType\CustomFields $customFields
     */
    public function __construct($saleOrderCode = null, \StructType\ReversePickupItems $reversePickupItems = null, \StructType\Address $address = null, $actionCode = null, \StructType\CustomFields $customFields = null)
    {
        $this
            ->setSaleOrderCode($saleOrderCode)
            ->setReversePickupItems($reversePickupItems)
            ->setAddress($address)
            ->setActionCode($actionCode)
            ->setCustomFields($customFields);
    }
    /**
     * Get SaleOrderCode value
     * @return string|null
     */
    public function getSaleOrderCode()
    {
        return $this->SaleOrderCode;
    }
    /**
     * Set SaleOrderCode value
     * @param string $saleOrderCode
     * @return \StructType\CreateReversePickupRequest
     */
    public function setSaleOrderCode($saleOrderCode = null)
    {
        // validation for constraint: string
        if (!is_null($saleOrderCode) && !is_string($saleOrderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleOrderCode, true), gettype($saleOrderCode)), __LINE__);
        }
        $this->SaleOrderCode = $saleOrderCode;
        return $this;
    }
    /**
     * Get ReversePickupItems value
     * @return \StructType\ReversePickupItems|null
     */
    public function getReversePickupItems()
    {
        return $this->ReversePickupItems;
    }
    /**
     * Set ReversePickupItems value
     * @param \StructType\ReversePickupItems $reversePickupItems
     * @return \StructType\CreateReversePickupRequest
     */
    public function setReversePickupItems(\StructType\ReversePickupItems $reversePickupItems = null)
    {
        $this->ReversePickupItems = $reversePickupItems;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\Address $address
     * @return \StructType\CreateReversePickupRequest
     */
    public function setAddress(\StructType\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ActionCode value
     * @return string|null
     */
    public function getActionCode()
    {
        return $this->ActionCode;
    }
    /**
     * Set ActionCode value
     * @param string $actionCode
     * @return \StructType\CreateReversePickupRequest
     */
    public function setActionCode($actionCode = null)
    {
        // validation for constraint: string
        if (!is_null($actionCode) && !is_string($actionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionCode, true), gettype($actionCode)), __LINE__);
        }
        $this->ActionCode = $actionCode;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \StructType\CustomFields|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \StructType\CustomFields $customFields
     * @return \StructType\CreateReversePickupRequest
     */
    public function setCustomFields(\StructType\CustomFields $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateReversePickupRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
