<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateGatePassRequest StructType
 * @subpackage Structs
 */
class CreateGatePassRequest extends AbstractStructBase
{
    /**
     * The WsGatePass
     * @var \StructType\WsGatePass
     */
    public $WsGatePass;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The PartyCode
     * @var string
     */
    public $PartyCode;
    /**
     * Constructor method for CreateGatePassRequest
     * @uses CreateGatePassRequest::setWsGatePass()
     * @uses CreateGatePassRequest::setType()
     * @uses CreateGatePassRequest::setPartyCode()
     * @param \StructType\WsGatePass $wsGatePass
     * @param string $type
     * @param string $partyCode
     */
    public function __construct(\StructType\WsGatePass $wsGatePass = null, $type = null, $partyCode = null)
    {
        $this
            ->setWsGatePass($wsGatePass)
            ->setType($type)
            ->setPartyCode($partyCode);
    }
    /**
     * Get WsGatePass value
     * @return \StructType\WsGatePass|null
     */
    public function getWsGatePass()
    {
        return $this->WsGatePass;
    }
    /**
     * Set WsGatePass value
     * @param \StructType\WsGatePass $wsGatePass
     * @return \StructType\CreateGatePassRequest
     */
    public function setWsGatePass(\StructType\WsGatePass $wsGatePass = null)
    {
        $this->WsGatePass = $wsGatePass;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\CreateGatePassRequest
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get PartyCode value
     * @return string|null
     */
    public function getPartyCode()
    {
        return $this->PartyCode;
    }
    /**
     * Set PartyCode value
     * @param string $partyCode
     * @return \StructType\CreateGatePassRequest
     */
    public function setPartyCode($partyCode = null)
    {
        // validation for constraint: string
        if (!is_null($partyCode) && !is_string($partyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partyCode, true), gettype($partyCode)), __LINE__);
        }
        $this->PartyCode = $partyCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateGatePassRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
