<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddEditVendorInvoiceItemRequest StructType
 * @subpackage Structs
 */
class AddEditVendorInvoiceItemRequest extends AbstractStructBase
{
    /**
     * The VendorInvoiceCode
     * @var string
     */
    public $VendorInvoiceCode;
    /**
     * The VendorInvoiceItems
     * @var \StructType\VendorInvoiceItems
     */
    public $VendorInvoiceItems;
    /**
     * Constructor method for AddEditVendorInvoiceItemRequest
     * @uses AddEditVendorInvoiceItemRequest::setVendorInvoiceCode()
     * @uses AddEditVendorInvoiceItemRequest::setVendorInvoiceItems()
     * @param string $vendorInvoiceCode
     * @param \StructType\VendorInvoiceItems $vendorInvoiceItems
     */
    public function __construct($vendorInvoiceCode = null, \StructType\VendorInvoiceItems $vendorInvoiceItems = null)
    {
        $this
            ->setVendorInvoiceCode($vendorInvoiceCode)
            ->setVendorInvoiceItems($vendorInvoiceItems);
    }
    /**
     * Get VendorInvoiceCode value
     * @return string|null
     */
    public function getVendorInvoiceCode()
    {
        return $this->VendorInvoiceCode;
    }
    /**
     * Set VendorInvoiceCode value
     * @param string $vendorInvoiceCode
     * @return \StructType\AddEditVendorInvoiceItemRequest
     */
    public function setVendorInvoiceCode($vendorInvoiceCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorInvoiceCode) && !is_string($vendorInvoiceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorInvoiceCode, true), gettype($vendorInvoiceCode)), __LINE__);
        }
        $this->VendorInvoiceCode = $vendorInvoiceCode;
        return $this;
    }
    /**
     * Get VendorInvoiceItems value
     * @return \StructType\VendorInvoiceItems|null
     */
    public function getVendorInvoiceItems()
    {
        return $this->VendorInvoiceItems;
    }
    /**
     * Set VendorInvoiceItems value
     * @param \StructType\VendorInvoiceItems $vendorInvoiceItems
     * @return \StructType\AddEditVendorInvoiceItemRequest
     */
    public function setVendorInvoiceItems(\StructType\VendorInvoiceItems $vendorInvoiceItems = null)
    {
        $this->VendorInvoiceItems = $vendorInvoiceItems;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddEditVendorInvoiceItemRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
