<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Inventory ServiceType
 * @subpackage Services
 */
class Inventory extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named InventoryAdjustment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InventoryAdjustmentRequest $inventoryAdjustmentRequest
     * @return \StructType\ServiceResponse|bool
     */
    public function InventoryAdjustment(\StructType\InventoryAdjustmentRequest $inventoryAdjustmentRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->InventoryAdjustment($inventoryAdjustmentRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ServiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
