<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Accept ServiceType
 * @subpackage Services
 */
class Accept extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AcceptSaleOrderItemAlternate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AcceptSaleOrderItemAlternateRequest $acceptSaleOrderItemAlternateRequest
     * @return \StructType\ServiceResponse|bool
     */
    public function AcceptSaleOrderItemAlternate(\StructType\AcceptSaleOrderItemAlternateRequest $acceptSaleOrderItemAlternateRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->AcceptSaleOrderItemAlternate($acceptSaleOrderItemAlternateRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ServiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
