<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Transfer StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Transfer
 * @subpackage Structs
 */
class Transfer extends DictionaryBase
{
    /**
     * The CtKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CtKey;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Duration;
    /**
     * The PlaceFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PlaceFrom;
    /**
     * The PlaceTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PlaceTo;
    /**
     * The TimeBegin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TimeBegin;
    /**
     * The TimeEnd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TimeEnd;
    /**
     * Constructor method for Transfer
     * @uses Transfer::setCtKey()
     * @uses Transfer::setDuration()
     * @uses Transfer::setPlaceFrom()
     * @uses Transfer::setPlaceTo()
     * @uses Transfer::setTimeBegin()
     * @uses Transfer::setTimeEnd()
     * @param int $ctKey
     * @param string $duration
     * @param string $placeFrom
     * @param string $placeTo
     * @param string $timeBegin
     * @param string $timeEnd
     */
    public function __construct($ctKey = null, $duration = null, $placeFrom = null, $placeTo = null, $timeBegin = null, $timeEnd = null)
    {
        $this
            ->setCtKey($ctKey)
            ->setDuration($duration)
            ->setPlaceFrom($placeFrom)
            ->setPlaceTo($placeTo)
            ->setTimeBegin($timeBegin)
            ->setTimeEnd($timeEnd);
    }
    /**
     * Get CtKey value
     * @return int|null
     */
    public function getCtKey()
    {
        return $this->CtKey;
    }
    /**
     * Set CtKey value
     * @param int $ctKey
     * @return \StructType\Transfer
     */
    public function setCtKey($ctKey = null)
    {
        // validation for constraint: int
        if (!is_null($ctKey) && !(is_int($ctKey) || ctype_digit($ctKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ctKey, true), gettype($ctKey)), __LINE__);
        }
        $this->CtKey = $ctKey;
        return $this;
    }
    /**
     * Get Duration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDuration()
    {
        return isset($this->Duration) ? $this->Duration : null;
    }
    /**
     * Set Duration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $duration
     * @return \StructType\Transfer
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        if (is_null($duration) || (is_array($duration) && empty($duration))) {
            unset($this->Duration);
        } else {
            $this->Duration = $duration;
        }
        return $this;
    }
    /**
     * Get PlaceFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlaceFrom()
    {
        return isset($this->PlaceFrom) ? $this->PlaceFrom : null;
    }
    /**
     * Set PlaceFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $placeFrom
     * @return \StructType\Transfer
     */
    public function setPlaceFrom($placeFrom = null)
    {
        // validation for constraint: string
        if (!is_null($placeFrom) && !is_string($placeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($placeFrom, true), gettype($placeFrom)), __LINE__);
        }
        if (is_null($placeFrom) || (is_array($placeFrom) && empty($placeFrom))) {
            unset($this->PlaceFrom);
        } else {
            $this->PlaceFrom = $placeFrom;
        }
        return $this;
    }
    /**
     * Get PlaceTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlaceTo()
    {
        return isset($this->PlaceTo) ? $this->PlaceTo : null;
    }
    /**
     * Set PlaceTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $placeTo
     * @return \StructType\Transfer
     */
    public function setPlaceTo($placeTo = null)
    {
        // validation for constraint: string
        if (!is_null($placeTo) && !is_string($placeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($placeTo, true), gettype($placeTo)), __LINE__);
        }
        if (is_null($placeTo) || (is_array($placeTo) && empty($placeTo))) {
            unset($this->PlaceTo);
        } else {
            $this->PlaceTo = $placeTo;
        }
        return $this;
    }
    /**
     * Get TimeBegin value
     * @return string|null
     */
    public function getTimeBegin()
    {
        return $this->TimeBegin;
    }
    /**
     * Set TimeBegin value
     * @param string $timeBegin
     * @return \StructType\Transfer
     */
    public function setTimeBegin($timeBegin = null)
    {
        // validation for constraint: string
        if (!is_null($timeBegin) && !is_string($timeBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeBegin, true), gettype($timeBegin)), __LINE__);
        }
        $this->TimeBegin = $timeBegin;
        return $this;
    }
    /**
     * Get TimeEnd value
     * @return string|null
     */
    public function getTimeEnd()
    {
        return $this->TimeEnd;
    }
    /**
     * Set TimeEnd value
     * @param string $timeEnd
     * @return \StructType\Transfer
     */
    public function setTimeEnd($timeEnd = null)
    {
        // validation for constraint: string
        if (!is_null($timeEnd) && !is_string($timeEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeEnd, true), gettype($timeEnd)), __LINE__);
        }
        $this->TimeEnd = $timeEnd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Transfer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
