<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TourDirection StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TourDirection
 * @subpackage Structs
 */
class TourDirection extends AbstractStructBase
{
    /**
     * The ArrivalCityId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ArrivalCityId;
    /**
     * The CountryId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CountryId;
    /**
     * The DepartureId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DepartureId;
    /**
     * The TransportKindId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TransportKindId;
    /**
     * Constructor method for TourDirection
     * @uses TourDirection::setArrivalCityId()
     * @uses TourDirection::setCountryId()
     * @uses TourDirection::setDepartureId()
     * @uses TourDirection::setTransportKindId()
     * @param int $arrivalCityId
     * @param int $countryId
     * @param int $departureId
     * @param int $transportKindId
     */
    public function __construct($arrivalCityId = null, $countryId = null, $departureId = null, $transportKindId = null)
    {
        $this
            ->setArrivalCityId($arrivalCityId)
            ->setCountryId($countryId)
            ->setDepartureId($departureId)
            ->setTransportKindId($transportKindId);
    }
    /**
     * Get ArrivalCityId value
     * @return int|null
     */
    public function getArrivalCityId()
    {
        return $this->ArrivalCityId;
    }
    /**
     * Set ArrivalCityId value
     * @param int $arrivalCityId
     * @return \StructType\TourDirection
     */
    public function setArrivalCityId($arrivalCityId = null)
    {
        // validation for constraint: int
        if (!is_null($arrivalCityId) && !(is_int($arrivalCityId) || ctype_digit($arrivalCityId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($arrivalCityId, true), gettype($arrivalCityId)), __LINE__);
        }
        $this->ArrivalCityId = $arrivalCityId;
        return $this;
    }
    /**
     * Get CountryId value
     * @return int|null
     */
    public function getCountryId()
    {
        return $this->CountryId;
    }
    /**
     * Set CountryId value
     * @param int $countryId
     * @return \StructType\TourDirection
     */
    public function setCountryId($countryId = null)
    {
        // validation for constraint: int
        if (!is_null($countryId) && !(is_int($countryId) || ctype_digit($countryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countryId, true), gettype($countryId)), __LINE__);
        }
        $this->CountryId = $countryId;
        return $this;
    }
    /**
     * Get DepartureId value
     * @return int|null
     */
    public function getDepartureId()
    {
        return $this->DepartureId;
    }
    /**
     * Set DepartureId value
     * @param int $departureId
     * @return \StructType\TourDirection
     */
    public function setDepartureId($departureId = null)
    {
        // validation for constraint: int
        if (!is_null($departureId) && !(is_int($departureId) || ctype_digit($departureId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($departureId, true), gettype($departureId)), __LINE__);
        }
        $this->DepartureId = $departureId;
        return $this;
    }
    /**
     * Get TransportKindId value
     * @return int|null
     */
    public function getTransportKindId()
    {
        return $this->TransportKindId;
    }
    /**
     * Set TransportKindId value
     * @param int $transportKindId
     * @return \StructType\TourDirection
     */
    public function setTransportKindId($transportKindId = null)
    {
        // validation for constraint: int
        if (!is_null($transportKindId) && !(is_int($transportKindId) || ctype_digit($transportKindId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transportKindId, true), gettype($transportKindId)), __LINE__);
        }
        $this->TransportKindId = $transportKindId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TourDirection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
