<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TourDate StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TourDate
 * @subpackage Structs
 */
class TourDate extends DictionaryBase
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The Durations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Durations;
    /**
     * Constructor method for TourDate
     * @uses TourDate::setDate()
     * @uses TourDate::setDurations()
     * @param string $date
     * @param int $durations
     */
    public function __construct($date = null, $durations = null)
    {
        $this
            ->setDate($date)
            ->setDurations($durations);
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\TourDate
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Durations value
     * @return int|null
     */
    public function getDurations()
    {
        return $this->Durations;
    }
    /**
     * Set Durations value
     * @param int $durations
     * @return \StructType\TourDate
     */
    public function setDurations($durations = null)
    {
        // validation for constraint: int
        if (!is_null($durations) && !(is_int($durations) || ctype_digit($durations))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($durations, true), gettype($durations)), __LINE__);
        }
        $this->Durations = $durations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TourDate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
