<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tour StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Tour
 * @subpackage Structs
 */
class Tour extends DictionaryBase
{
    /**
     * The CityKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CityKey;
    /**
     * The CountryKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CountryKey;
    /**
     * The RateIso
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RateIso;
    /**
     * The TourURL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TourURL;
    /**
     * The TypeTour
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TypeTour;
    /**
     * The TypeTours
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $TypeTours;
    /**
     * Constructor method for Tour
     * @uses Tour::setCityKey()
     * @uses Tour::setCountryKey()
     * @uses Tour::setRateIso()
     * @uses Tour::setTourURL()
     * @uses Tour::setTypeTour()
     * @uses Tour::setTypeTours()
     * @param int $cityKey
     * @param int $countryKey
     * @param string $rateIso
     * @param string $tourURL
     * @param int $typeTour
     * @param \ArrayType\ArrayOfint $typeTours
     */
    public function __construct($cityKey = null, $countryKey = null, $rateIso = null, $tourURL = null, $typeTour = null, \ArrayType\ArrayOfint $typeTours = null)
    {
        $this
            ->setCityKey($cityKey)
            ->setCountryKey($countryKey)
            ->setRateIso($rateIso)
            ->setTourURL($tourURL)
            ->setTypeTour($typeTour)
            ->setTypeTours($typeTours);
    }
    /**
     * Get CityKey value
     * @return int|null
     */
    public function getCityKey()
    {
        return $this->CityKey;
    }
    /**
     * Set CityKey value
     * @param int $cityKey
     * @return \StructType\Tour
     */
    public function setCityKey($cityKey = null)
    {
        // validation for constraint: int
        if (!is_null($cityKey) && !(is_int($cityKey) || ctype_digit($cityKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cityKey, true), gettype($cityKey)), __LINE__);
        }
        $this->CityKey = $cityKey;
        return $this;
    }
    /**
     * Get CountryKey value
     * @return int|null
     */
    public function getCountryKey()
    {
        return $this->CountryKey;
    }
    /**
     * Set CountryKey value
     * @param int $countryKey
     * @return \StructType\Tour
     */
    public function setCountryKey($countryKey = null)
    {
        // validation for constraint: int
        if (!is_null($countryKey) && !(is_int($countryKey) || ctype_digit($countryKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countryKey, true), gettype($countryKey)), __LINE__);
        }
        $this->CountryKey = $countryKey;
        return $this;
    }
    /**
     * Get RateIso value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRateIso()
    {
        return isset($this->RateIso) ? $this->RateIso : null;
    }
    /**
     * Set RateIso value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rateIso
     * @return \StructType\Tour
     */
    public function setRateIso($rateIso = null)
    {
        // validation for constraint: string
        if (!is_null($rateIso) && !is_string($rateIso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateIso, true), gettype($rateIso)), __LINE__);
        }
        if (is_null($rateIso) || (is_array($rateIso) && empty($rateIso))) {
            unset($this->RateIso);
        } else {
            $this->RateIso = $rateIso;
        }
        return $this;
    }
    /**
     * Get TourURL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTourURL()
    {
        return isset($this->TourURL) ? $this->TourURL : null;
    }
    /**
     * Set TourURL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tourURL
     * @return \StructType\Tour
     */
    public function setTourURL($tourURL = null)
    {
        // validation for constraint: string
        if (!is_null($tourURL) && !is_string($tourURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tourURL, true), gettype($tourURL)), __LINE__);
        }
        if (is_null($tourURL) || (is_array($tourURL) && empty($tourURL))) {
            unset($this->TourURL);
        } else {
            $this->TourURL = $tourURL;
        }
        return $this;
    }
    /**
     * Get TypeTour value
     * @return int|null
     */
    public function getTypeTour()
    {
        return $this->TypeTour;
    }
    /**
     * Set TypeTour value
     * @param int $typeTour
     * @return \StructType\Tour
     */
    public function setTypeTour($typeTour = null)
    {
        // validation for constraint: int
        if (!is_null($typeTour) && !(is_int($typeTour) || ctype_digit($typeTour))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($typeTour, true), gettype($typeTour)), __LINE__);
        }
        $this->TypeTour = $typeTour;
        return $this;
    }
    /**
     * Get TypeTours value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getTypeTours()
    {
        return isset($this->TypeTours) ? $this->TypeTours : null;
    }
    /**
     * Set TypeTours value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $typeTours
     * @return \StructType\Tour
     */
    public function setTypeTours(\ArrayType\ArrayOfint $typeTours = null)
    {
        if (is_null($typeTours) || (is_array($typeTours) && empty($typeTours))) {
            unset($this->TypeTours);
        } else {
            $this->TypeTours = $typeTours;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Tour
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
