<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StatItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:StatItem
 * @subpackage Structs
 */
class StatItem extends AbstractStructBase
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The Hash
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Hash;
    /**
     * The IsComplete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsComplete;
    /**
     * The Stats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfStatValue
     */
    public $Stats;
    /**
     * Constructor method for StatItem
     * @uses StatItem::setDate()
     * @uses StatItem::setHash()
     * @uses StatItem::setIsComplete()
     * @uses StatItem::setStats()
     * @param string $date
     * @param int $hash
     * @param bool $isComplete
     * @param \ArrayType\ArrayOfStatValue $stats
     */
    public function __construct($date = null, $hash = null, $isComplete = null, \ArrayType\ArrayOfStatValue $stats = null)
    {
        $this
            ->setDate($date)
            ->setHash($hash)
            ->setIsComplete($isComplete)
            ->setStats($stats);
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\StatItem
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Hash value
     * @return int|null
     */
    public function getHash()
    {
        return $this->Hash;
    }
    /**
     * Set Hash value
     * @param int $hash
     * @return \StructType\StatItem
     */
    public function setHash($hash = null)
    {
        // validation for constraint: int
        if (!is_null($hash) && !(is_int($hash) || ctype_digit($hash))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hash, true), gettype($hash)), __LINE__);
        }
        $this->Hash = $hash;
        return $this;
    }
    /**
     * Get IsComplete value
     * @return bool|null
     */
    public function getIsComplete()
    {
        return $this->IsComplete;
    }
    /**
     * Set IsComplete value
     * @param bool $isComplete
     * @return \StructType\StatItem
     */
    public function setIsComplete($isComplete = null)
    {
        // validation for constraint: boolean
        if (!is_null($isComplete) && !is_bool($isComplete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isComplete, true), gettype($isComplete)), __LINE__);
        }
        $this->IsComplete = $isComplete;
        return $this;
    }
    /**
     * Get Stats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfStatValue|null
     */
    public function getStats()
    {
        return isset($this->Stats) ? $this->Stats : null;
    }
    /**
     * Set Stats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfStatValue $stats
     * @return \StructType\StatItem
     */
    public function setStats(\ArrayType\ArrayOfStatValue $stats = null)
    {
        if (is_null($stats) || (is_array($stats) && empty($stats))) {
            unset($this->Stats);
        } else {
            $this->Stats = $stats;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StatItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
