<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchGroupHotelResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SearchGroupHotelResult
 * @subpackage Structs
 */
class SearchGroupHotelResult extends AbstractStructBase
{
    /**
     * The HasMore
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasMore;
    /**
     * The TourHotelGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTourHotelGroup
     */
    public $TourHotelGroups;
    /**
     * Constructor method for SearchGroupHotelResult
     * @uses SearchGroupHotelResult::setHasMore()
     * @uses SearchGroupHotelResult::setTourHotelGroups()
     * @param bool $hasMore
     * @param \ArrayType\ArrayOfTourHotelGroup $tourHotelGroups
     */
    public function __construct($hasMore = null, \ArrayType\ArrayOfTourHotelGroup $tourHotelGroups = null)
    {
        $this
            ->setHasMore($hasMore)
            ->setTourHotelGroups($tourHotelGroups);
    }
    /**
     * Get HasMore value
     * @return bool|null
     */
    public function getHasMore()
    {
        return $this->HasMore;
    }
    /**
     * Set HasMore value
     * @param bool $hasMore
     * @return \StructType\SearchGroupHotelResult
     */
    public function setHasMore($hasMore = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasMore) && !is_bool($hasMore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasMore, true), gettype($hasMore)), __LINE__);
        }
        $this->HasMore = $hasMore;
        return $this;
    }
    /**
     * Get TourHotelGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTourHotelGroup|null
     */
    public function getTourHotelGroups()
    {
        return isset($this->TourHotelGroups) ? $this->TourHotelGroups : null;
    }
    /**
     * Set TourHotelGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTourHotelGroup $tourHotelGroups
     * @return \StructType\SearchGroupHotelResult
     */
    public function setTourHotelGroups(\ArrayType\ArrayOfTourHotelGroup $tourHotelGroups = null)
    {
        if (is_null($tourHotelGroups) || (is_array($tourHotelGroups) && empty($tourHotelGroups))) {
            unset($this->TourHotelGroups);
        } else {
            $this->TourHotelGroups = $tourHotelGroups;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchGroupHotelResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
