<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RealCourse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RealCourse
 * @subpackage Structs
 */
class RealCourse extends DictionaryBase
{
    /**
     * The CourseCB
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CourseCB;
    /**
     * The CourseInternal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CourseInternal;
    /**
     * The CourseTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CourseTotal;
    /**
     * The CurrencyCodeFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCodeFrom;
    /**
     * The CurrencyCodeTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCodeTo;
    /**
     * Constructor method for RealCourse
     * @uses RealCourse::setCourseCB()
     * @uses RealCourse::setCourseInternal()
     * @uses RealCourse::setCourseTotal()
     * @uses RealCourse::setCurrencyCodeFrom()
     * @uses RealCourse::setCurrencyCodeTo()
     * @param float $courseCB
     * @param float $courseInternal
     * @param float $courseTotal
     * @param string $currencyCodeFrom
     * @param string $currencyCodeTo
     */
    public function __construct($courseCB = null, $courseInternal = null, $courseTotal = null, $currencyCodeFrom = null, $currencyCodeTo = null)
    {
        $this
            ->setCourseCB($courseCB)
            ->setCourseInternal($courseInternal)
            ->setCourseTotal($courseTotal)
            ->setCurrencyCodeFrom($currencyCodeFrom)
            ->setCurrencyCodeTo($currencyCodeTo);
    }
    /**
     * Get CourseCB value
     * @return float|null
     */
    public function getCourseCB()
    {
        return $this->CourseCB;
    }
    /**
     * Set CourseCB value
     * @param float $courseCB
     * @return \StructType\RealCourse
     */
    public function setCourseCB($courseCB = null)
    {
        // validation for constraint: float
        if (!is_null($courseCB) && !(is_float($courseCB) || is_numeric($courseCB))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($courseCB, true), gettype($courseCB)), __LINE__);
        }
        $this->CourseCB = $courseCB;
        return $this;
    }
    /**
     * Get CourseInternal value
     * @return float|null
     */
    public function getCourseInternal()
    {
        return $this->CourseInternal;
    }
    /**
     * Set CourseInternal value
     * @param float $courseInternal
     * @return \StructType\RealCourse
     */
    public function setCourseInternal($courseInternal = null)
    {
        // validation for constraint: float
        if (!is_null($courseInternal) && !(is_float($courseInternal) || is_numeric($courseInternal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($courseInternal, true), gettype($courseInternal)), __LINE__);
        }
        $this->CourseInternal = $courseInternal;
        return $this;
    }
    /**
     * Get CourseTotal value
     * @return float|null
     */
    public function getCourseTotal()
    {
        return $this->CourseTotal;
    }
    /**
     * Set CourseTotal value
     * @param float $courseTotal
     * @return \StructType\RealCourse
     */
    public function setCourseTotal($courseTotal = null)
    {
        // validation for constraint: float
        if (!is_null($courseTotal) && !(is_float($courseTotal) || is_numeric($courseTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($courseTotal, true), gettype($courseTotal)), __LINE__);
        }
        $this->CourseTotal = $courseTotal;
        return $this;
    }
    /**
     * Get CurrencyCodeFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCodeFrom()
    {
        return isset($this->CurrencyCodeFrom) ? $this->CurrencyCodeFrom : null;
    }
    /**
     * Set CurrencyCodeFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCodeFrom
     * @return \StructType\RealCourse
     */
    public function setCurrencyCodeFrom($currencyCodeFrom = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCodeFrom) && !is_string($currencyCodeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCodeFrom, true), gettype($currencyCodeFrom)), __LINE__);
        }
        if (is_null($currencyCodeFrom) || (is_array($currencyCodeFrom) && empty($currencyCodeFrom))) {
            unset($this->CurrencyCodeFrom);
        } else {
            $this->CurrencyCodeFrom = $currencyCodeFrom;
        }
        return $this;
    }
    /**
     * Get CurrencyCodeTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCodeTo()
    {
        return isset($this->CurrencyCodeTo) ? $this->CurrencyCodeTo : null;
    }
    /**
     * Set CurrencyCodeTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCodeTo
     * @return \StructType\RealCourse
     */
    public function setCurrencyCodeTo($currencyCodeTo = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCodeTo) && !is_string($currencyCodeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCodeTo, true), gettype($currencyCodeTo)), __LINE__);
        }
        if (is_null($currencyCodeTo) || (is_array($currencyCodeTo) && empty($currencyCodeTo))) {
            unset($this->CurrencyCodeTo);
        } else {
            $this->CurrencyCodeTo = $currencyCodeTo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RealCourse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
