<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QuotaHotelRoomVariant StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:QuotaHotelRoomVariant
 * @subpackage Structs
 */
class QuotaHotelRoomVariant extends AbstractStructBase
{
    /**
     * The Accomodations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAccommodation
     */
    public $Accomodations;
    /**
     * The HotelGlobalRoomCategoryKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $HotelGlobalRoomCategoryKey;
    /**
     * The HotelRoomCategoryKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $HotelRoomCategoryKey;
    /**
     * The HotelRoomTypeKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $HotelRoomTypeKey;
    /**
     * The QuotaDateStates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfQuotaDateState
     */
    public $QuotaDateStates;
    /**
     * The RoomVariant
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RoomVariant;
    /**
     * The TouristCountDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TouristCountDetail
     */
    public $TouristCountDetail;
    /**
     * Constructor method for QuotaHotelRoomVariant
     * @uses QuotaHotelRoomVariant::setAccomodations()
     * @uses QuotaHotelRoomVariant::setHotelGlobalRoomCategoryKey()
     * @uses QuotaHotelRoomVariant::setHotelRoomCategoryKey()
     * @uses QuotaHotelRoomVariant::setHotelRoomTypeKey()
     * @uses QuotaHotelRoomVariant::setQuotaDateStates()
     * @uses QuotaHotelRoomVariant::setRoomVariant()
     * @uses QuotaHotelRoomVariant::setTouristCountDetail()
     * @param \ArrayType\ArrayOfAccommodation $accomodations
     * @param int $hotelGlobalRoomCategoryKey
     * @param int $hotelRoomCategoryKey
     * @param int $hotelRoomTypeKey
     * @param \ArrayType\ArrayOfQuotaDateState $quotaDateStates
     * @param string $roomVariant
     * @param \StructType\TouristCountDetail $touristCountDetail
     */
    public function __construct(\ArrayType\ArrayOfAccommodation $accomodations = null, $hotelGlobalRoomCategoryKey = null, $hotelRoomCategoryKey = null, $hotelRoomTypeKey = null, \ArrayType\ArrayOfQuotaDateState $quotaDateStates = null, $roomVariant = null, \StructType\TouristCountDetail $touristCountDetail = null)
    {
        $this
            ->setAccomodations($accomodations)
            ->setHotelGlobalRoomCategoryKey($hotelGlobalRoomCategoryKey)
            ->setHotelRoomCategoryKey($hotelRoomCategoryKey)
            ->setHotelRoomTypeKey($hotelRoomTypeKey)
            ->setQuotaDateStates($quotaDateStates)
            ->setRoomVariant($roomVariant)
            ->setTouristCountDetail($touristCountDetail);
    }
    /**
     * Get Accomodations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAccommodation|null
     */
    public function getAccomodations()
    {
        return isset($this->Accomodations) ? $this->Accomodations : null;
    }
    /**
     * Set Accomodations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAccommodation $accomodations
     * @return \StructType\QuotaHotelRoomVariant
     */
    public function setAccomodations(\ArrayType\ArrayOfAccommodation $accomodations = null)
    {
        if (is_null($accomodations) || (is_array($accomodations) && empty($accomodations))) {
            unset($this->Accomodations);
        } else {
            $this->Accomodations = $accomodations;
        }
        return $this;
    }
    /**
     * Get HotelGlobalRoomCategoryKey value
     * @return int|null
     */
    public function getHotelGlobalRoomCategoryKey()
    {
        return $this->HotelGlobalRoomCategoryKey;
    }
    /**
     * Set HotelGlobalRoomCategoryKey value
     * @param int $hotelGlobalRoomCategoryKey
     * @return \StructType\QuotaHotelRoomVariant
     */
    public function setHotelGlobalRoomCategoryKey($hotelGlobalRoomCategoryKey = null)
    {
        // validation for constraint: int
        if (!is_null($hotelGlobalRoomCategoryKey) && !(is_int($hotelGlobalRoomCategoryKey) || ctype_digit($hotelGlobalRoomCategoryKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hotelGlobalRoomCategoryKey, true), gettype($hotelGlobalRoomCategoryKey)), __LINE__);
        }
        $this->HotelGlobalRoomCategoryKey = $hotelGlobalRoomCategoryKey;
        return $this;
    }
    /**
     * Get HotelRoomCategoryKey value
     * @return int|null
     */
    public function getHotelRoomCategoryKey()
    {
        return $this->HotelRoomCategoryKey;
    }
    /**
     * Set HotelRoomCategoryKey value
     * @param int $hotelRoomCategoryKey
     * @return \StructType\QuotaHotelRoomVariant
     */
    public function setHotelRoomCategoryKey($hotelRoomCategoryKey = null)
    {
        // validation for constraint: int
        if (!is_null($hotelRoomCategoryKey) && !(is_int($hotelRoomCategoryKey) || ctype_digit($hotelRoomCategoryKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hotelRoomCategoryKey, true), gettype($hotelRoomCategoryKey)), __LINE__);
        }
        $this->HotelRoomCategoryKey = $hotelRoomCategoryKey;
        return $this;
    }
    /**
     * Get HotelRoomTypeKey value
     * @return int|null
     */
    public function getHotelRoomTypeKey()
    {
        return $this->HotelRoomTypeKey;
    }
    /**
     * Set HotelRoomTypeKey value
     * @param int $hotelRoomTypeKey
     * @return \StructType\QuotaHotelRoomVariant
     */
    public function setHotelRoomTypeKey($hotelRoomTypeKey = null)
    {
        // validation for constraint: int
        if (!is_null($hotelRoomTypeKey) && !(is_int($hotelRoomTypeKey) || ctype_digit($hotelRoomTypeKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hotelRoomTypeKey, true), gettype($hotelRoomTypeKey)), __LINE__);
        }
        $this->HotelRoomTypeKey = $hotelRoomTypeKey;
        return $this;
    }
    /**
     * Get QuotaDateStates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfQuotaDateState|null
     */
    public function getQuotaDateStates()
    {
        return isset($this->QuotaDateStates) ? $this->QuotaDateStates : null;
    }
    /**
     * Set QuotaDateStates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfQuotaDateState $quotaDateStates
     * @return \StructType\QuotaHotelRoomVariant
     */
    public function setQuotaDateStates(\ArrayType\ArrayOfQuotaDateState $quotaDateStates = null)
    {
        if (is_null($quotaDateStates) || (is_array($quotaDateStates) && empty($quotaDateStates))) {
            unset($this->QuotaDateStates);
        } else {
            $this->QuotaDateStates = $quotaDateStates;
        }
        return $this;
    }
    /**
     * Get RoomVariant value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoomVariant()
    {
        return isset($this->RoomVariant) ? $this->RoomVariant : null;
    }
    /**
     * Set RoomVariant value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $roomVariant
     * @return \StructType\QuotaHotelRoomVariant
     */
    public function setRoomVariant($roomVariant = null)
    {
        // validation for constraint: string
        if (!is_null($roomVariant) && !is_string($roomVariant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomVariant, true), gettype($roomVariant)), __LINE__);
        }
        if (is_null($roomVariant) || (is_array($roomVariant) && empty($roomVariant))) {
            unset($this->RoomVariant);
        } else {
            $this->RoomVariant = $roomVariant;
        }
        return $this;
    }
    /**
     * Get TouristCountDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TouristCountDetail|null
     */
    public function getTouristCountDetail()
    {
        return isset($this->TouristCountDetail) ? $this->TouristCountDetail : null;
    }
    /**
     * Set TouristCountDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\TouristCountDetail $touristCountDetail
     * @return \StructType\QuotaHotelRoomVariant
     */
    public function setTouristCountDetail(\StructType\TouristCountDetail $touristCountDetail = null)
    {
        if (is_null($touristCountDetail) || (is_array($touristCountDetail) && empty($touristCountDetail))) {
            unset($this->TouristCountDetail);
        } else {
            $this->TouristCountDetail = $touristCountDetail;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QuotaHotelRoomVariant
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
