<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QuotaFlightTariffState StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:QuotaFlightTariffState
 * @subpackage Structs
 */
class QuotaFlightTariffState extends AbstractStructBase
{
    /**
     * The Airseason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Airseason;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * Constructor method for QuotaFlightTariffState
     * @uses QuotaFlightTariffState::setAirseason()
     * @uses QuotaFlightTariffState::setDate()
     * @uses QuotaFlightTariffState::setState()
     * @param string $airseason
     * @param string $date
     * @param string $state
     */
    public function __construct($airseason = null, $date = null, $state = null)
    {
        $this
            ->setAirseason($airseason)
            ->setDate($date)
            ->setState($state);
    }
    /**
     * Get Airseason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAirseason()
    {
        return isset($this->Airseason) ? $this->Airseason : null;
    }
    /**
     * Set Airseason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $airseason
     * @return \StructType\QuotaFlightTariffState
     */
    public function setAirseason($airseason = null)
    {
        // validation for constraint: string
        if (!is_null($airseason) && !is_string($airseason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airseason, true), gettype($airseason)), __LINE__);
        }
        if (is_null($airseason) || (is_array($airseason) && empty($airseason))) {
            unset($this->Airseason);
        } else {
            $this->Airseason = $airseason;
        }
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\QuotaFlightTariffState
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @uses \EnumType\QuotaState::valueIsValid()
     * @uses \EnumType\QuotaState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \StructType\QuotaFlightTariffState
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\QuotaState::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\QuotaState', is_array($state) ? implode(', ', $state) : var_export($state, true), implode(', ', \EnumType\QuotaState::getValidValues())), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QuotaFlightTariffState
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
