<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QuotaDateState StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:QuotaDateState
 * @subpackage Structs
 */
class QuotaDateState extends AbstractStructBase
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * Constructor method for QuotaDateState
     * @uses QuotaDateState::setDate()
     * @uses QuotaDateState::setState()
     * @param string $date
     * @param string $state
     */
    public function __construct($date = null, $state = null)
    {
        $this
            ->setDate($date)
            ->setState($state);
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\QuotaDateState
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @uses \EnumType\QuotaState::valueIsValid()
     * @uses \EnumType\QuotaState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \StructType\QuotaDateState
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\QuotaState::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\QuotaState', is_array($state) ? implode(', ', $state) : var_export($state, true), implode(', ', \EnumType\QuotaState::getValidValues())), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QuotaDateState
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
