<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceListDataPerPax StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PriceListDataPerPax
 * @subpackage Structs
 */
class PriceListDataPerPax extends AbstractStructBase
{
    /**
     * The ArrivalCityID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ArrivalCityID;
    /**
     * The CountryID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CountryID;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DepartureCityID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DepartureCityID;
    /**
     * The FlightProgram
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FlightProgram
     */
    public $FlightProgram;
    /**
     * The HotelPriceSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfHotelPriceScheduleItem
     */
    public $HotelPriceSchedule;
    /**
     * The HotelsPerTourVariantCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $HotelsPerTourVariantCount;
    /**
     * The IncludedServiceClasses
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $IncludedServiceClasses;
    /**
     * The MarketID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MarketID;
    /**
     * The TourName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TourName;
    /**
     * The TourNameLat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TourNameLat;
    /**
     * The TourTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $TourTypes;
    /**
     * The TransportKindID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TransportKindID;
    /**
     * Constructor method for PriceListDataPerPax
     * @uses PriceListDataPerPax::setArrivalCityID()
     * @uses PriceListDataPerPax::setCountryID()
     * @uses PriceListDataPerPax::setCurrencyCode()
     * @uses PriceListDataPerPax::setDepartureCityID()
     * @uses PriceListDataPerPax::setFlightProgram()
     * @uses PriceListDataPerPax::setHotelPriceSchedule()
     * @uses PriceListDataPerPax::setHotelsPerTourVariantCount()
     * @uses PriceListDataPerPax::setIncludedServiceClasses()
     * @uses PriceListDataPerPax::setMarketID()
     * @uses PriceListDataPerPax::setTourName()
     * @uses PriceListDataPerPax::setTourNameLat()
     * @uses PriceListDataPerPax::setTourTypes()
     * @uses PriceListDataPerPax::setTransportKindID()
     * @param int $arrivalCityID
     * @param int $countryID
     * @param string $currencyCode
     * @param int $departureCityID
     * @param \StructType\FlightProgram $flightProgram
     * @param \ArrayType\ArrayOfHotelPriceScheduleItem $hotelPriceSchedule
     * @param int $hotelsPerTourVariantCount
     * @param \ArrayType\ArrayOfint $includedServiceClasses
     * @param int $marketID
     * @param string $tourName
     * @param string $tourNameLat
     * @param \ArrayType\ArrayOfint $tourTypes
     * @param int $transportKindID
     */
    public function __construct($arrivalCityID = null, $countryID = null, $currencyCode = null, $departureCityID = null, \StructType\FlightProgram $flightProgram = null, \ArrayType\ArrayOfHotelPriceScheduleItem $hotelPriceSchedule = null, $hotelsPerTourVariantCount = null, \ArrayType\ArrayOfint $includedServiceClasses = null, $marketID = null, $tourName = null, $tourNameLat = null, \ArrayType\ArrayOfint $tourTypes = null, $transportKindID = null)
    {
        $this
            ->setArrivalCityID($arrivalCityID)
            ->setCountryID($countryID)
            ->setCurrencyCode($currencyCode)
            ->setDepartureCityID($departureCityID)
            ->setFlightProgram($flightProgram)
            ->setHotelPriceSchedule($hotelPriceSchedule)
            ->setHotelsPerTourVariantCount($hotelsPerTourVariantCount)
            ->setIncludedServiceClasses($includedServiceClasses)
            ->setMarketID($marketID)
            ->setTourName($tourName)
            ->setTourNameLat($tourNameLat)
            ->setTourTypes($tourTypes)
            ->setTransportKindID($transportKindID);
    }
    /**
     * Get ArrivalCityID value
     * @return int|null
     */
    public function getArrivalCityID()
    {
        return $this->ArrivalCityID;
    }
    /**
     * Set ArrivalCityID value
     * @param int $arrivalCityID
     * @return \StructType\PriceListDataPerPax
     */
    public function setArrivalCityID($arrivalCityID = null)
    {
        // validation for constraint: int
        if (!is_null($arrivalCityID) && !(is_int($arrivalCityID) || ctype_digit($arrivalCityID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($arrivalCityID, true), gettype($arrivalCityID)), __LINE__);
        }
        $this->ArrivalCityID = $arrivalCityID;
        return $this;
    }
    /**
     * Get CountryID value
     * @return int|null
     */
    public function getCountryID()
    {
        return $this->CountryID;
    }
    /**
     * Set CountryID value
     * @param int $countryID
     * @return \StructType\PriceListDataPerPax
     */
    public function setCountryID($countryID = null)
    {
        // validation for constraint: int
        if (!is_null($countryID) && !(is_int($countryID) || ctype_digit($countryID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countryID, true), gettype($countryID)), __LINE__);
        }
        $this->CountryID = $countryID;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \StructType\PriceListDataPerPax
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
    /**
     * Get DepartureCityID value
     * @return int|null
     */
    public function getDepartureCityID()
    {
        return $this->DepartureCityID;
    }
    /**
     * Set DepartureCityID value
     * @param int $departureCityID
     * @return \StructType\PriceListDataPerPax
     */
    public function setDepartureCityID($departureCityID = null)
    {
        // validation for constraint: int
        if (!is_null($departureCityID) && !(is_int($departureCityID) || ctype_digit($departureCityID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($departureCityID, true), gettype($departureCityID)), __LINE__);
        }
        $this->DepartureCityID = $departureCityID;
        return $this;
    }
    /**
     * Get FlightProgram value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FlightProgram|null
     */
    public function getFlightProgram()
    {
        return isset($this->FlightProgram) ? $this->FlightProgram : null;
    }
    /**
     * Set FlightProgram value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FlightProgram $flightProgram
     * @return \StructType\PriceListDataPerPax
     */
    public function setFlightProgram(\StructType\FlightProgram $flightProgram = null)
    {
        if (is_null($flightProgram) || (is_array($flightProgram) && empty($flightProgram))) {
            unset($this->FlightProgram);
        } else {
            $this->FlightProgram = $flightProgram;
        }
        return $this;
    }
    /**
     * Get HotelPriceSchedule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfHotelPriceScheduleItem|null
     */
    public function getHotelPriceSchedule()
    {
        return isset($this->HotelPriceSchedule) ? $this->HotelPriceSchedule : null;
    }
    /**
     * Set HotelPriceSchedule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfHotelPriceScheduleItem $hotelPriceSchedule
     * @return \StructType\PriceListDataPerPax
     */
    public function setHotelPriceSchedule(\ArrayType\ArrayOfHotelPriceScheduleItem $hotelPriceSchedule = null)
    {
        if (is_null($hotelPriceSchedule) || (is_array($hotelPriceSchedule) && empty($hotelPriceSchedule))) {
            unset($this->HotelPriceSchedule);
        } else {
            $this->HotelPriceSchedule = $hotelPriceSchedule;
        }
        return $this;
    }
    /**
     * Get HotelsPerTourVariantCount value
     * @return int|null
     */
    public function getHotelsPerTourVariantCount()
    {
        return $this->HotelsPerTourVariantCount;
    }
    /**
     * Set HotelsPerTourVariantCount value
     * @param int $hotelsPerTourVariantCount
     * @return \StructType\PriceListDataPerPax
     */
    public function setHotelsPerTourVariantCount($hotelsPerTourVariantCount = null)
    {
        // validation for constraint: int
        if (!is_null($hotelsPerTourVariantCount) && !(is_int($hotelsPerTourVariantCount) || ctype_digit($hotelsPerTourVariantCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hotelsPerTourVariantCount, true), gettype($hotelsPerTourVariantCount)), __LINE__);
        }
        $this->HotelsPerTourVariantCount = $hotelsPerTourVariantCount;
        return $this;
    }
    /**
     * Get IncludedServiceClasses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getIncludedServiceClasses()
    {
        return isset($this->IncludedServiceClasses) ? $this->IncludedServiceClasses : null;
    }
    /**
     * Set IncludedServiceClasses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $includedServiceClasses
     * @return \StructType\PriceListDataPerPax
     */
    public function setIncludedServiceClasses(\ArrayType\ArrayOfint $includedServiceClasses = null)
    {
        if (is_null($includedServiceClasses) || (is_array($includedServiceClasses) && empty($includedServiceClasses))) {
            unset($this->IncludedServiceClasses);
        } else {
            $this->IncludedServiceClasses = $includedServiceClasses;
        }
        return $this;
    }
    /**
     * Get MarketID value
     * @return int|null
     */
    public function getMarketID()
    {
        return $this->MarketID;
    }
    /**
     * Set MarketID value
     * @param int $marketID
     * @return \StructType\PriceListDataPerPax
     */
    public function setMarketID($marketID = null)
    {
        // validation for constraint: int
        if (!is_null($marketID) && !(is_int($marketID) || ctype_digit($marketID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($marketID, true), gettype($marketID)), __LINE__);
        }
        $this->MarketID = $marketID;
        return $this;
    }
    /**
     * Get TourName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTourName()
    {
        return isset($this->TourName) ? $this->TourName : null;
    }
    /**
     * Set TourName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tourName
     * @return \StructType\PriceListDataPerPax
     */
    public function setTourName($tourName = null)
    {
        // validation for constraint: string
        if (!is_null($tourName) && !is_string($tourName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tourName, true), gettype($tourName)), __LINE__);
        }
        if (is_null($tourName) || (is_array($tourName) && empty($tourName))) {
            unset($this->TourName);
        } else {
            $this->TourName = $tourName;
        }
        return $this;
    }
    /**
     * Get TourNameLat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTourNameLat()
    {
        return isset($this->TourNameLat) ? $this->TourNameLat : null;
    }
    /**
     * Set TourNameLat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tourNameLat
     * @return \StructType\PriceListDataPerPax
     */
    public function setTourNameLat($tourNameLat = null)
    {
        // validation for constraint: string
        if (!is_null($tourNameLat) && !is_string($tourNameLat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tourNameLat, true), gettype($tourNameLat)), __LINE__);
        }
        if (is_null($tourNameLat) || (is_array($tourNameLat) && empty($tourNameLat))) {
            unset($this->TourNameLat);
        } else {
            $this->TourNameLat = $tourNameLat;
        }
        return $this;
    }
    /**
     * Get TourTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getTourTypes()
    {
        return isset($this->TourTypes) ? $this->TourTypes : null;
    }
    /**
     * Set TourTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $tourTypes
     * @return \StructType\PriceListDataPerPax
     */
    public function setTourTypes(\ArrayType\ArrayOfint $tourTypes = null)
    {
        if (is_null($tourTypes) || (is_array($tourTypes) && empty($tourTypes))) {
            unset($this->TourTypes);
        } else {
            $this->TourTypes = $tourTypes;
        }
        return $this;
    }
    /**
     * Get TransportKindID value
     * @return int|null
     */
    public function getTransportKindID()
    {
        return $this->TransportKindID;
    }
    /**
     * Set TransportKindID value
     * @param int $transportKindID
     * @return \StructType\PriceListDataPerPax
     */
    public function setTransportKindID($transportKindID = null)
    {
        // validation for constraint: int
        if (!is_null($transportKindID) && !(is_int($transportKindID) || ctype_digit($transportKindID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transportKindID, true), gettype($transportKindID)), __LINE__);
        }
        $this->TransportKindID = $transportKindID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PriceListDataPerPax
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
