<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelPriceScheduleItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:HotelPriceScheduleItem
 * @subpackage Structs
 */
class HotelPriceScheduleItem extends AbstractStructBase
{
    /**
     * The HotelID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $HotelID;
    /**
     * The HotelNights
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HotelNights;
    /**
     * The HotelRoomPrices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfHotelRoomPrice
     */
    public $HotelRoomPrices;
    /**
     * The TourDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TourDate;
    /**
     * The TourDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TourDays;
    /**
     * Constructor method for HotelPriceScheduleItem
     * @uses HotelPriceScheduleItem::setHotelID()
     * @uses HotelPriceScheduleItem::setHotelNights()
     * @uses HotelPriceScheduleItem::setHotelRoomPrices()
     * @uses HotelPriceScheduleItem::setTourDate()
     * @uses HotelPriceScheduleItem::setTourDays()
     * @param int $hotelID
     * @param string $hotelNights
     * @param \ArrayType\ArrayOfHotelRoomPrice $hotelRoomPrices
     * @param string $tourDate
     * @param string $tourDays
     */
    public function __construct($hotelID = null, $hotelNights = null, \ArrayType\ArrayOfHotelRoomPrice $hotelRoomPrices = null, $tourDate = null, $tourDays = null)
    {
        $this
            ->setHotelID($hotelID)
            ->setHotelNights($hotelNights)
            ->setHotelRoomPrices($hotelRoomPrices)
            ->setTourDate($tourDate)
            ->setTourDays($tourDays);
    }
    /**
     * Get HotelID value
     * @return int|null
     */
    public function getHotelID()
    {
        return $this->HotelID;
    }
    /**
     * Set HotelID value
     * @param int $hotelID
     * @return \StructType\HotelPriceScheduleItem
     */
    public function setHotelID($hotelID = null)
    {
        // validation for constraint: int
        if (!is_null($hotelID) && !(is_int($hotelID) || ctype_digit($hotelID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hotelID, true), gettype($hotelID)), __LINE__);
        }
        $this->HotelID = $hotelID;
        return $this;
    }
    /**
     * Get HotelNights value
     * @return string|null
     */
    public function getHotelNights()
    {
        return $this->HotelNights;
    }
    /**
     * Set HotelNights value
     * @param string $hotelNights
     * @return \StructType\HotelPriceScheduleItem
     */
    public function setHotelNights($hotelNights = null)
    {
        // validation for constraint: string
        if (!is_null($hotelNights) && !is_string($hotelNights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelNights, true), gettype($hotelNights)), __LINE__);
        }
        $this->HotelNights = $hotelNights;
        return $this;
    }
    /**
     * Get HotelRoomPrices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfHotelRoomPrice|null
     */
    public function getHotelRoomPrices()
    {
        return isset($this->HotelRoomPrices) ? $this->HotelRoomPrices : null;
    }
    /**
     * Set HotelRoomPrices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfHotelRoomPrice $hotelRoomPrices
     * @return \StructType\HotelPriceScheduleItem
     */
    public function setHotelRoomPrices(\ArrayType\ArrayOfHotelRoomPrice $hotelRoomPrices = null)
    {
        if (is_null($hotelRoomPrices) || (is_array($hotelRoomPrices) && empty($hotelRoomPrices))) {
            unset($this->HotelRoomPrices);
        } else {
            $this->HotelRoomPrices = $hotelRoomPrices;
        }
        return $this;
    }
    /**
     * Get TourDate value
     * @return string|null
     */
    public function getTourDate()
    {
        return $this->TourDate;
    }
    /**
     * Set TourDate value
     * @param string $tourDate
     * @return \StructType\HotelPriceScheduleItem
     */
    public function setTourDate($tourDate = null)
    {
        // validation for constraint: string
        if (!is_null($tourDate) && !is_string($tourDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tourDate, true), gettype($tourDate)), __LINE__);
        }
        $this->TourDate = $tourDate;
        return $this;
    }
    /**
     * Get TourDays value
     * @return string|null
     */
    public function getTourDays()
    {
        return $this->TourDays;
    }
    /**
     * Set TourDays value
     * @param string $tourDays
     * @return \StructType\HotelPriceScheduleItem
     */
    public function setTourDays($tourDays = null)
    {
        // validation for constraint: string
        if (!is_null($tourDays) && !is_string($tourDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tourDays, true), gettype($tourDays)), __LINE__);
        }
        $this->TourDays = $tourDays;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelPriceScheduleItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
