<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Hotel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Hotel
 * @subpackage Structs
 */
class Hotel extends DictionaryBase
{
    /**
     * The CityID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CityID;
    /**
     * The CountryID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CountryID;
    /**
     * The HTTP
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HTTP;
    /**
     * The HotelCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HotelCategory;
    /**
     * The HotelCategoryGlobal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HotelCategoryGlobal;
    /**
     * The HotelCategoryGlobalID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $HotelCategoryGlobalID;
    /**
     * The HotelCategoryID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $HotelCategoryID;
    /**
     * The HotelTown
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HotelTown;
    /**
     * The HotelTownLat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HotelTownLat;
    /**
     * The Rating
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Rating;
    /**
     * Constructor method for Hotel
     * @uses Hotel::setCityID()
     * @uses Hotel::setCountryID()
     * @uses Hotel::setHTTP()
     * @uses Hotel::setHotelCategory()
     * @uses Hotel::setHotelCategoryGlobal()
     * @uses Hotel::setHotelCategoryGlobalID()
     * @uses Hotel::setHotelCategoryID()
     * @uses Hotel::setHotelTown()
     * @uses Hotel::setHotelTownLat()
     * @uses Hotel::setRating()
     * @param int $cityID
     * @param int $countryID
     * @param string $hTTP
     * @param string $hotelCategory
     * @param string $hotelCategoryGlobal
     * @param int $hotelCategoryGlobalID
     * @param int $hotelCategoryID
     * @param string $hotelTown
     * @param string $hotelTownLat
     * @param float $rating
     */
    public function __construct($cityID = null, $countryID = null, $hTTP = null, $hotelCategory = null, $hotelCategoryGlobal = null, $hotelCategoryGlobalID = null, $hotelCategoryID = null, $hotelTown = null, $hotelTownLat = null, $rating = null)
    {
        $this
            ->setCityID($cityID)
            ->setCountryID($countryID)
            ->setHTTP($hTTP)
            ->setHotelCategory($hotelCategory)
            ->setHotelCategoryGlobal($hotelCategoryGlobal)
            ->setHotelCategoryGlobalID($hotelCategoryGlobalID)
            ->setHotelCategoryID($hotelCategoryID)
            ->setHotelTown($hotelTown)
            ->setHotelTownLat($hotelTownLat)
            ->setRating($rating);
    }
    /**
     * Get CityID value
     * @return int|null
     */
    public function getCityID()
    {
        return $this->CityID;
    }
    /**
     * Set CityID value
     * @param int $cityID
     * @return \StructType\Hotel
     */
    public function setCityID($cityID = null)
    {
        // validation for constraint: int
        if (!is_null($cityID) && !(is_int($cityID) || ctype_digit($cityID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cityID, true), gettype($cityID)), __LINE__);
        }
        $this->CityID = $cityID;
        return $this;
    }
    /**
     * Get CountryID value
     * @return int|null
     */
    public function getCountryID()
    {
        return $this->CountryID;
    }
    /**
     * Set CountryID value
     * @param int $countryID
     * @return \StructType\Hotel
     */
    public function setCountryID($countryID = null)
    {
        // validation for constraint: int
        if (!is_null($countryID) && !(is_int($countryID) || ctype_digit($countryID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countryID, true), gettype($countryID)), __LINE__);
        }
        $this->CountryID = $countryID;
        return $this;
    }
    /**
     * Get HTTP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHTTP()
    {
        return isset($this->HTTP) ? $this->HTTP : null;
    }
    /**
     * Set HTTP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hTTP
     * @return \StructType\Hotel
     */
    public function setHTTP($hTTP = null)
    {
        // validation for constraint: string
        if (!is_null($hTTP) && !is_string($hTTP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hTTP, true), gettype($hTTP)), __LINE__);
        }
        if (is_null($hTTP) || (is_array($hTTP) && empty($hTTP))) {
            unset($this->HTTP);
        } else {
            $this->HTTP = $hTTP;
        }
        return $this;
    }
    /**
     * Get HotelCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHotelCategory()
    {
        return isset($this->HotelCategory) ? $this->HotelCategory : null;
    }
    /**
     * Set HotelCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hotelCategory
     * @return \StructType\Hotel
     */
    public function setHotelCategory($hotelCategory = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCategory) && !is_string($hotelCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCategory, true), gettype($hotelCategory)), __LINE__);
        }
        if (is_null($hotelCategory) || (is_array($hotelCategory) && empty($hotelCategory))) {
            unset($this->HotelCategory);
        } else {
            $this->HotelCategory = $hotelCategory;
        }
        return $this;
    }
    /**
     * Get HotelCategoryGlobal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHotelCategoryGlobal()
    {
        return isset($this->HotelCategoryGlobal) ? $this->HotelCategoryGlobal : null;
    }
    /**
     * Set HotelCategoryGlobal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hotelCategoryGlobal
     * @return \StructType\Hotel
     */
    public function setHotelCategoryGlobal($hotelCategoryGlobal = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCategoryGlobal) && !is_string($hotelCategoryGlobal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCategoryGlobal, true), gettype($hotelCategoryGlobal)), __LINE__);
        }
        if (is_null($hotelCategoryGlobal) || (is_array($hotelCategoryGlobal) && empty($hotelCategoryGlobal))) {
            unset($this->HotelCategoryGlobal);
        } else {
            $this->HotelCategoryGlobal = $hotelCategoryGlobal;
        }
        return $this;
    }
    /**
     * Get HotelCategoryGlobalID value
     * @return int|null
     */
    public function getHotelCategoryGlobalID()
    {
        return $this->HotelCategoryGlobalID;
    }
    /**
     * Set HotelCategoryGlobalID value
     * @param int $hotelCategoryGlobalID
     * @return \StructType\Hotel
     */
    public function setHotelCategoryGlobalID($hotelCategoryGlobalID = null)
    {
        // validation for constraint: int
        if (!is_null($hotelCategoryGlobalID) && !(is_int($hotelCategoryGlobalID) || ctype_digit($hotelCategoryGlobalID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hotelCategoryGlobalID, true), gettype($hotelCategoryGlobalID)), __LINE__);
        }
        $this->HotelCategoryGlobalID = $hotelCategoryGlobalID;
        return $this;
    }
    /**
     * Get HotelCategoryID value
     * @return int|null
     */
    public function getHotelCategoryID()
    {
        return $this->HotelCategoryID;
    }
    /**
     * Set HotelCategoryID value
     * @param int $hotelCategoryID
     * @return \StructType\Hotel
     */
    public function setHotelCategoryID($hotelCategoryID = null)
    {
        // validation for constraint: int
        if (!is_null($hotelCategoryID) && !(is_int($hotelCategoryID) || ctype_digit($hotelCategoryID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hotelCategoryID, true), gettype($hotelCategoryID)), __LINE__);
        }
        $this->HotelCategoryID = $hotelCategoryID;
        return $this;
    }
    /**
     * Get HotelTown value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHotelTown()
    {
        return isset($this->HotelTown) ? $this->HotelTown : null;
    }
    /**
     * Set HotelTown value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hotelTown
     * @return \StructType\Hotel
     */
    public function setHotelTown($hotelTown = null)
    {
        // validation for constraint: string
        if (!is_null($hotelTown) && !is_string($hotelTown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelTown, true), gettype($hotelTown)), __LINE__);
        }
        if (is_null($hotelTown) || (is_array($hotelTown) && empty($hotelTown))) {
            unset($this->HotelTown);
        } else {
            $this->HotelTown = $hotelTown;
        }
        return $this;
    }
    /**
     * Get HotelTownLat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHotelTownLat()
    {
        return isset($this->HotelTownLat) ? $this->HotelTownLat : null;
    }
    /**
     * Set HotelTownLat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hotelTownLat
     * @return \StructType\Hotel
     */
    public function setHotelTownLat($hotelTownLat = null)
    {
        // validation for constraint: string
        if (!is_null($hotelTownLat) && !is_string($hotelTownLat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelTownLat, true), gettype($hotelTownLat)), __LINE__);
        }
        if (is_null($hotelTownLat) || (is_array($hotelTownLat) && empty($hotelTownLat))) {
            unset($this->HotelTownLat);
        } else {
            $this->HotelTownLat = $hotelTownLat;
        }
        return $this;
    }
    /**
     * Get Rating value
     * @return float|null
     */
    public function getRating()
    {
        return $this->Rating;
    }
    /**
     * Set Rating value
     * @param float $rating
     * @return \StructType\Hotel
     */
    public function setRating($rating = null)
    {
        // validation for constraint: float
        if (!is_null($rating) && !(is_float($rating) || is_numeric($rating))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rating, true), gettype($rating)), __LINE__);
        }
        $this->Rating = $rating;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Hotel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
