<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetFilter5 StructType
 * @subpackage Structs
 */
class GetFilter5 extends AbstractStructBase
{
    /**
     * The filter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FilterParametr
     */
    public $filter;
    /**
     * The changedItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $changedItem;
    /**
     * Constructor method for GetFilter5
     * @uses GetFilter5::setFilter()
     * @uses GetFilter5::setChangedItem()
     * @param \StructType\FilterParametr $filter
     * @param string $changedItem
     */
    public function __construct(\StructType\FilterParametr $filter = null, $changedItem = null)
    {
        $this
            ->setFilter($filter)
            ->setChangedItem($changedItem);
    }
    /**
     * Get filter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FilterParametr|null
     */
    public function getFilter()
    {
        return isset($this->filter) ? $this->filter : null;
    }
    /**
     * Set filter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FilterParametr $filter
     * @return \StructType\GetFilter5
     */
    public function setFilter(\StructType\FilterParametr $filter = null)
    {
        if (is_null($filter) || (is_array($filter) && empty($filter))) {
            unset($this->filter);
        } else {
            $this->filter = $filter;
        }
        return $this;
    }
    /**
     * Get changedItem value
     * @return string|null
     */
    public function getChangedItem()
    {
        return $this->changedItem;
    }
    /**
     * Set changedItem value
     * @uses \EnumType\DictionaryEnum::valueIsValid()
     * @uses \EnumType\DictionaryEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $changedItem
     * @return \StructType\GetFilter5
     */
    public function setChangedItem($changedItem = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DictionaryEnum::valueIsValid($changedItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DictionaryEnum', is_array($changedItem) ? implode(', ', $changedItem) : var_export($changedItem, true), implode(', ', \EnumType\DictionaryEnum::getValidValues())), __LINE__);
        }
        $this->changedItem = $changedItem;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetFilter5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
