<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDictionary StructType
 * @subpackage Structs
 */
class GetDictionary extends AbstractStructBase
{
    /**
     * The country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $country;
    /**
     * The cityDepartures
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $cityDepartures;
    /**
     * The dictionaries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDictionaryEnum
     */
    public $dictionaries;
    /**
     * Constructor method for GetDictionary
     * @uses GetDictionary::setCountry()
     * @uses GetDictionary::setCityDepartures()
     * @uses GetDictionary::setDictionaries()
     * @param int $country
     * @param \ArrayType\ArrayOfint $cityDepartures
     * @param \ArrayType\ArrayOfDictionaryEnum $dictionaries
     */
    public function __construct($country = null, \ArrayType\ArrayOfint $cityDepartures = null, \ArrayType\ArrayOfDictionaryEnum $dictionaries = null)
    {
        $this
            ->setCountry($country)
            ->setCityDepartures($cityDepartures)
            ->setDictionaries($dictionaries);
    }
    /**
     * Get country value
     * @return int|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param int $country
     * @return \StructType\GetDictionary
     */
    public function setCountry($country = null)
    {
        // validation for constraint: int
        if (!is_null($country) && !(is_int($country) || ctype_digit($country))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get cityDepartures value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getCityDepartures()
    {
        return isset($this->cityDepartures) ? $this->cityDepartures : null;
    }
    /**
     * Set cityDepartures value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $cityDepartures
     * @return \StructType\GetDictionary
     */
    public function setCityDepartures(\ArrayType\ArrayOfint $cityDepartures = null)
    {
        if (is_null($cityDepartures) || (is_array($cityDepartures) && empty($cityDepartures))) {
            unset($this->cityDepartures);
        } else {
            $this->cityDepartures = $cityDepartures;
        }
        return $this;
    }
    /**
     * Get dictionaries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDictionaryEnum|null
     */
    public function getDictionaries()
    {
        return isset($this->dictionaries) ? $this->dictionaries : null;
    }
    /**
     * Set dictionaries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDictionaryEnum $dictionaries
     * @return \StructType\GetDictionary
     */
    public function setDictionaries(\ArrayType\ArrayOfDictionaryEnum $dictionaries = null)
    {
        if (is_null($dictionaries) || (is_array($dictionaries) && empty($dictionaries))) {
            unset($this->dictionaries);
        } else {
            $this->dictionaries = $dictionaries;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDictionary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
