<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDictionaries StructType
 * @subpackage Structs
 */
class GetDictionaries extends AbstractStructBase
{
    /**
     * The sender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $sender;
    /**
     * The dictionaries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDictionaryEnum
     */
    public $dictionaries;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $country;
    /**
     * The cityDepartures
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $cityDepartures;
    /**
     * Constructor method for GetDictionaries
     * @uses GetDictionaries::setSender()
     * @uses GetDictionaries::setDictionaries()
     * @uses GetDictionaries::setCountry()
     * @uses GetDictionaries::setCityDepartures()
     * @param string $sender
     * @param \ArrayType\ArrayOfDictionaryEnum $dictionaries
     * @param int $country
     * @param \ArrayType\ArrayOfint $cityDepartures
     */
    public function __construct($sender = null, \ArrayType\ArrayOfDictionaryEnum $dictionaries = null, $country = null, \ArrayType\ArrayOfint $cityDepartures = null)
    {
        $this
            ->setSender($sender)
            ->setDictionaries($dictionaries)
            ->setCountry($country)
            ->setCityDepartures($cityDepartures);
    }
    /**
     * Get sender value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSender()
    {
        return isset($this->sender) ? $this->sender : null;
    }
    /**
     * Set sender value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sender
     * @return \StructType\GetDictionaries
     */
    public function setSender($sender = null)
    {
        // validation for constraint: string
        if (!is_null($sender) && !is_string($sender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sender, true), gettype($sender)), __LINE__);
        }
        if (is_null($sender) || (is_array($sender) && empty($sender))) {
            unset($this->sender);
        } else {
            $this->sender = $sender;
        }
        return $this;
    }
    /**
     * Get dictionaries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDictionaryEnum|null
     */
    public function getDictionaries()
    {
        return isset($this->dictionaries) ? $this->dictionaries : null;
    }
    /**
     * Set dictionaries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDictionaryEnum $dictionaries
     * @return \StructType\GetDictionaries
     */
    public function setDictionaries(\ArrayType\ArrayOfDictionaryEnum $dictionaries = null)
    {
        if (is_null($dictionaries) || (is_array($dictionaries) && empty($dictionaries))) {
            unset($this->dictionaries);
        } else {
            $this->dictionaries = $dictionaries;
        }
        return $this;
    }
    /**
     * Get country value
     * @return int|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param int $country
     * @return \StructType\GetDictionaries
     */
    public function setCountry($country = null)
    {
        // validation for constraint: int
        if (!is_null($country) && !(is_int($country) || ctype_digit($country))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get cityDepartures value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getCityDepartures()
    {
        return isset($this->cityDepartures) ? $this->cityDepartures : null;
    }
    /**
     * Set cityDepartures value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $cityDepartures
     * @return \StructType\GetDictionaries
     */
    public function setCityDepartures(\ArrayType\ArrayOfint $cityDepartures = null)
    {
        if (is_null($cityDepartures) || (is_array($cityDepartures) && empty($cityDepartures))) {
            unset($this->cityDepartures);
        } else {
            $this->cityDepartures = $cityDepartures;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDictionaries
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
