<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightService StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FlightService
 * @subpackage Structs
 */
class FlightService extends AbstractStructBase
{
    /**
     * The CharterKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CharterKey;
    /**
     * The Day
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Day;
    /**
     * Constructor method for FlightService
     * @uses FlightService::setCharterKey()
     * @uses FlightService::setDay()
     * @param int $charterKey
     * @param string $day
     */
    public function __construct($charterKey = null, $day = null)
    {
        $this
            ->setCharterKey($charterKey)
            ->setDay($day);
    }
    /**
     * Get CharterKey value
     * @return int|null
     */
    public function getCharterKey()
    {
        return $this->CharterKey;
    }
    /**
     * Set CharterKey value
     * @param int $charterKey
     * @return \StructType\FlightService
     */
    public function setCharterKey($charterKey = null)
    {
        // validation for constraint: int
        if (!is_null($charterKey) && !(is_int($charterKey) || ctype_digit($charterKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($charterKey, true), gettype($charterKey)), __LINE__);
        }
        $this->CharterKey = $charterKey;
        return $this;
    }
    /**
     * Get Day value
     * @return string|null
     */
    public function getDay()
    {
        return $this->Day;
    }
    /**
     * Set Day value
     * @param string $day
     * @return \StructType\FlightService
     */
    public function setDay($day = null)
    {
        // validation for constraint: string
        if (!is_null($day) && !is_string($day)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($day, true), gettype($day)), __LINE__);
        }
        $this->Day = $day;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FlightService
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
