<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DictionaryBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DictionaryBase
 * @subpackage Structs
 */
class DictionaryBase extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The CodeGlobal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodeGlobal;
    /**
     * The GroupName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GroupName;
    /**
     * The GroupNameLat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GroupNameLat;
    /**
     * The GroupOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $GroupOrder;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The NameLat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NameLat;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Order;
    /**
     * Constructor method for DictionaryBase
     * @uses DictionaryBase::setCode()
     * @uses DictionaryBase::setCodeGlobal()
     * @uses DictionaryBase::setGroupName()
     * @uses DictionaryBase::setGroupNameLat()
     * @uses DictionaryBase::setGroupOrder()
     * @uses DictionaryBase::setID()
     * @uses DictionaryBase::setName()
     * @uses DictionaryBase::setNameLat()
     * @uses DictionaryBase::setOrder()
     * @param string $code
     * @param string $codeGlobal
     * @param string $groupName
     * @param string $groupNameLat
     * @param int $groupOrder
     * @param int $iD
     * @param string $name
     * @param string $nameLat
     * @param int $order
     */
    public function __construct($code = null, $codeGlobal = null, $groupName = null, $groupNameLat = null, $groupOrder = null, $iD = null, $name = null, $nameLat = null, $order = null)
    {
        $this
            ->setCode($code)
            ->setCodeGlobal($codeGlobal)
            ->setGroupName($groupName)
            ->setGroupNameLat($groupNameLat)
            ->setGroupOrder($groupOrder)
            ->setID($iD)
            ->setName($name)
            ->setNameLat($nameLat)
            ->setOrder($order);
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \StructType\DictionaryBase
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get CodeGlobal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeGlobal()
    {
        return isset($this->CodeGlobal) ? $this->CodeGlobal : null;
    }
    /**
     * Set CodeGlobal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codeGlobal
     * @return \StructType\DictionaryBase
     */
    public function setCodeGlobal($codeGlobal = null)
    {
        // validation for constraint: string
        if (!is_null($codeGlobal) && !is_string($codeGlobal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeGlobal, true), gettype($codeGlobal)), __LINE__);
        }
        if (is_null($codeGlobal) || (is_array($codeGlobal) && empty($codeGlobal))) {
            unset($this->CodeGlobal);
        } else {
            $this->CodeGlobal = $codeGlobal;
        }
        return $this;
    }
    /**
     * Get GroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupName()
    {
        return isset($this->GroupName) ? $this->GroupName : null;
    }
    /**
     * Set GroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupName
     * @return \StructType\DictionaryBase
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupName, true), gettype($groupName)), __LINE__);
        }
        if (is_null($groupName) || (is_array($groupName) && empty($groupName))) {
            unset($this->GroupName);
        } else {
            $this->GroupName = $groupName;
        }
        return $this;
    }
    /**
     * Get GroupNameLat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupNameLat()
    {
        return isset($this->GroupNameLat) ? $this->GroupNameLat : null;
    }
    /**
     * Set GroupNameLat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupNameLat
     * @return \StructType\DictionaryBase
     */
    public function setGroupNameLat($groupNameLat = null)
    {
        // validation for constraint: string
        if (!is_null($groupNameLat) && !is_string($groupNameLat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupNameLat, true), gettype($groupNameLat)), __LINE__);
        }
        if (is_null($groupNameLat) || (is_array($groupNameLat) && empty($groupNameLat))) {
            unset($this->GroupNameLat);
        } else {
            $this->GroupNameLat = $groupNameLat;
        }
        return $this;
    }
    /**
     * Get GroupOrder value
     * @return int|null
     */
    public function getGroupOrder()
    {
        return $this->GroupOrder;
    }
    /**
     * Set GroupOrder value
     * @param int $groupOrder
     * @return \StructType\DictionaryBase
     */
    public function setGroupOrder($groupOrder = null)
    {
        // validation for constraint: int
        if (!is_null($groupOrder) && !(is_int($groupOrder) || ctype_digit($groupOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groupOrder, true), gettype($groupOrder)), __LINE__);
        }
        $this->GroupOrder = $groupOrder;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\DictionaryBase
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\DictionaryBase
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NameLat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNameLat()
    {
        return isset($this->NameLat) ? $this->NameLat : null;
    }
    /**
     * Set NameLat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nameLat
     * @return \StructType\DictionaryBase
     */
    public function setNameLat($nameLat = null)
    {
        // validation for constraint: string
        if (!is_null($nameLat) && !is_string($nameLat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameLat, true), gettype($nameLat)), __LINE__);
        }
        if (is_null($nameLat) || (is_array($nameLat) && empty($nameLat))) {
            unset($this->NameLat);
        } else {
            $this->NameLat = $nameLat;
        }
        return $this;
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\DictionaryBase
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DictionaryBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
