<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChildPrice StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ChildPrice
 * @subpackage Structs
 */
class ChildPrice extends AbstractStructBase
{
    /**
     * The AgeFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AgeFrom;
    /**
     * The AgeTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AgeTo;
    /**
     * The Prices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $Prices;
    /**
     * Constructor method for ChildPrice
     * @uses ChildPrice::setAgeFrom()
     * @uses ChildPrice::setAgeTo()
     * @uses ChildPrice::setPrices()
     * @param string $ageFrom
     * @param string $ageTo
     * @param \ArrayType\ArrayOfint $prices
     */
    public function __construct($ageFrom = null, $ageTo = null, \ArrayType\ArrayOfint $prices = null)
    {
        $this
            ->setAgeFrom($ageFrom)
            ->setAgeTo($ageTo)
            ->setPrices($prices);
    }
    /**
     * Get AgeFrom value
     * @return string|null
     */
    public function getAgeFrom()
    {
        return $this->AgeFrom;
    }
    /**
     * Set AgeFrom value
     * @param string $ageFrom
     * @return \StructType\ChildPrice
     */
    public function setAgeFrom($ageFrom = null)
    {
        // validation for constraint: string
        if (!is_null($ageFrom) && !is_string($ageFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ageFrom, true), gettype($ageFrom)), __LINE__);
        }
        $this->AgeFrom = $ageFrom;
        return $this;
    }
    /**
     * Get AgeTo value
     * @return string|null
     */
    public function getAgeTo()
    {
        return $this->AgeTo;
    }
    /**
     * Set AgeTo value
     * @param string $ageTo
     * @return \StructType\ChildPrice
     */
    public function setAgeTo($ageTo = null)
    {
        // validation for constraint: string
        if (!is_null($ageTo) && !is_string($ageTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ageTo, true), gettype($ageTo)), __LINE__);
        }
        $this->AgeTo = $ageTo;
        return $this;
    }
    /**
     * Get Prices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getPrices()
    {
        return isset($this->Prices) ? $this->Prices : null;
    }
    /**
     * Set Prices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $prices
     * @return \StructType\ChildPrice
     */
    public function setPrices(\ArrayType\ArrayOfint $prices = null)
    {
        if (is_null($prices) || (is_array($prices) && empty($prices))) {
            unset($this->Prices);
        } else {
            $this->Prices = $prices;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChildPrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
