<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BaseRequest
 * @subpackage Structs
 */
class BaseRequest extends AbstractStructBase
{
    /**
     * The AuthData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthData;
    /**
     * The Localization
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Localization;
    /**
     * The MarketId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MarketId;
    /**
     * Constructor method for BaseRequest
     * @uses BaseRequest::setAuthData()
     * @uses BaseRequest::setLocalization()
     * @uses BaseRequest::setMarketId()
     * @param string $authData
     * @param string $localization
     * @param int $marketId
     */
    public function __construct($authData = null, $localization = null, $marketId = null)
    {
        $this
            ->setAuthData($authData)
            ->setLocalization($localization)
            ->setMarketId($marketId);
    }
    /**
     * Get AuthData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthData()
    {
        return isset($this->AuthData) ? $this->AuthData : null;
    }
    /**
     * Set AuthData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authData
     * @return \StructType\BaseRequest
     */
    public function setAuthData($authData = null)
    {
        // validation for constraint: string
        if (!is_null($authData) && !is_string($authData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authData, true), gettype($authData)), __LINE__);
        }
        if (is_null($authData) || (is_array($authData) && empty($authData))) {
            unset($this->AuthData);
        } else {
            $this->AuthData = $authData;
        }
        return $this;
    }
    /**
     * Get Localization value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocalization()
    {
        return isset($this->Localization) ? $this->Localization : null;
    }
    /**
     * Set Localization value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $localization
     * @return \StructType\BaseRequest
     */
    public function setLocalization($localization = null)
    {
        // validation for constraint: string
        if (!is_null($localization) && !is_string($localization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localization, true), gettype($localization)), __LINE__);
        }
        if (is_null($localization) || (is_array($localization) && empty($localization))) {
            unset($this->Localization);
        } else {
            $this->Localization = $localization;
        }
        return $this;
    }
    /**
     * Get MarketId value
     * @return int|null
     */
    public function getMarketId()
    {
        return $this->MarketId;
    }
    /**
     * Set MarketId value
     * @param int $marketId
     * @return \StructType\BaseRequest
     */
    public function setMarketId($marketId = null)
    {
        // validation for constraint: int
        if (!is_null($marketId) && !(is_int($marketId) || ctype_digit($marketId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($marketId, true), gettype($marketId)), __LINE__);
        }
        $this->MarketId = $marketId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaseRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
