<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Airport StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Airport
 * @subpackage Structs
 */
class Airport extends DictionaryBase
{
    /**
     * The CtKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CtKey;
    /**
     * Constructor method for Airport
     * @uses Airport::setCtKey()
     * @param int $ctKey
     */
    public function __construct($ctKey = null)
    {
        $this
            ->setCtKey($ctKey);
    }
    /**
     * Get CtKey value
     * @return int|null
     */
    public function getCtKey()
    {
        return $this->CtKey;
    }
    /**
     * Set CtKey value
     * @param int $ctKey
     * @return \StructType\Airport
     */
    public function setCtKey($ctKey = null)
    {
        // validation for constraint: int
        if (!is_null($ctKey) && !(is_int($ctKey) || ctype_digit($ctKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ctKey, true), gettype($ctKey)), __LINE__);
        }
        $this->CtKey = $ctKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Airport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
